/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif.transforms;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import pl.droidsonroids.gif.transforms.Transform;

public class CornerRadiusTransform
implements Transform {
    private float mCornerRadius;
    private Shader mShader;
    private final RectF mDstRectF = new RectF();

    public CornerRadiusTransform(@FloatRange(from=0.0) float cornerRadius) {
        this.setCornerRadiusSafely(cornerRadius);
    }

    public void setCornerRadius(@FloatRange(from=0.0) float cornerRadius) {
        this.setCornerRadiusSafely(cornerRadius);
    }

    private void setCornerRadiusSafely(@FloatRange(from=0.0) float cornerRadius) {
        if ((cornerRadius = Math.max(0.0f, cornerRadius)) != this.mCornerRadius) {
            this.mCornerRadius = cornerRadius;
            this.mShader = null;
        }
    }

    @FloatRange(from=0.0)
    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    @NonNull
    public RectF getBounds() {
        return this.mDstRectF;
    }

    @Override
    public void onBoundsChange(Rect bounds) {
        this.mDstRectF.set(bounds);
        this.mShader = null;
    }

    @Override
    public void onDraw(Canvas canvas, Paint paint, Bitmap buffer) {
        if (this.mCornerRadius == 0.0f) {
            canvas.drawBitmap(buffer, null, this.mDstRectF, paint);
            return;
        }
        if (this.mShader == null) {
            this.mShader = new BitmapShader(buffer, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            Matrix shaderMatrix = new Matrix();
            shaderMatrix.setTranslate(this.mDstRectF.left, this.mDstRectF.top);
            shaderMatrix.preScale(this.mDstRectF.width() / (float)buffer.getWidth(), this.mDstRectF.height() / (float)buffer.getHeight());
            this.mShader.setLocalMatrix(shaderMatrix);
        }
        paint.setShader(this.mShader);
        canvas.drawRoundRect(this.mDstRectF, this.mCornerRadius, this.mCornerRadius, paint);
    }
}

