/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.widget.ImageButton;
import android.widget.ImageView;
import pl.droidsonroids.gif.GifViewSavedState;
import pl.droidsonroids.gif.GifViewUtils;

public class GifImageButton
extends ImageButton {
    private boolean mFreezesAnimation;

    public GifImageButton(Context context) {
        super(context);
    }

    public GifImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.postInit(GifViewUtils.initImageView((ImageView)this, attrs, 0, 0));
    }

    public GifImageButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.postInit(GifViewUtils.initImageView((ImageView)this, attrs, defStyle, 0));
    }

    @RequiresApi(value=21)
    public GifImageButton(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs, defStyle, defStyleRes);
        this.postInit(GifViewUtils.initImageView((ImageView)this, attrs, defStyle, defStyleRes));
    }

    private void postInit(GifViewUtils.GifImageViewAttributes result) {
        this.mFreezesAnimation = result.freezesAnimation;
        if (result.mSourceResId > 0) {
            super.setImageResource(result.mSourceResId);
        }
        if (result.mBackgroundResId > 0) {
            super.setBackgroundResource(result.mBackgroundResId);
        }
    }

    public void setImageURI(Uri uri) {
        if (!GifViewUtils.setGifImageUri((ImageView)this, uri)) {
            super.setImageURI(uri);
        }
    }

    public void setImageResource(int resId) {
        if (!GifViewUtils.setResource((ImageView)this, true, resId)) {
            super.setImageResource(resId);
        }
    }

    public void setBackgroundResource(int resId) {
        if (!GifViewUtils.setResource((ImageView)this, false, resId)) {
            super.setBackgroundResource(resId);
        }
    }

    public Parcelable onSaveInstanceState() {
        Drawable source = this.mFreezesAnimation ? this.getDrawable() : null;
        Drawable background = this.mFreezesAnimation ? this.getBackground() : null;
        return new GifViewSavedState(super.onSaveInstanceState(), source, background);
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof GifViewSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        GifViewSavedState ss = (GifViewSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        ss.restoreState(this.getDrawable(), 0);
        ss.restoreState(this.getBackground(), 1);
    }

    public void setFreezesAnimation(boolean freezesAnimation) {
        this.mFreezesAnimation = freezesAnimation;
    }
}

