/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.graphics.drawable.Drawable;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;

public class MultiCallback
implements Drawable.Callback {
    private final CopyOnWriteArrayList<CallbackWeakReference> mCallbacks = new CopyOnWriteArrayList();

    public void invalidateDrawable(Drawable who) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            CallbackWeakReference reference = this.mCallbacks.get(i);
            Drawable.Callback callback = (Drawable.Callback)reference.get();
            if (callback != null) {
                callback.invalidateDrawable(who);
                continue;
            }
            this.mCallbacks.remove(reference);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            CallbackWeakReference reference = this.mCallbacks.get(i);
            Drawable.Callback callback = (Drawable.Callback)reference.get();
            if (callback != null) {
                callback.scheduleDrawable(who, what, when);
                continue;
            }
            this.mCallbacks.remove(reference);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            CallbackWeakReference reference = this.mCallbacks.get(i);
            Drawable.Callback callback = (Drawable.Callback)reference.get();
            if (callback != null) {
                callback.unscheduleDrawable(who, what);
                continue;
            }
            this.mCallbacks.remove(reference);
        }
    }

    public void addView(Drawable.Callback callback) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            CallbackWeakReference reference = this.mCallbacks.get(i);
            Drawable.Callback item = (Drawable.Callback)reference.get();
            if (item != null) continue;
            this.mCallbacks.remove(reference);
        }
        this.mCallbacks.addIfAbsent(new CallbackWeakReference(callback));
    }

    public void removeView(Drawable.Callback callback) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            CallbackWeakReference reference = this.mCallbacks.get(i);
            Drawable.Callback item = (Drawable.Callback)reference.get();
            if (item != null && item != callback) continue;
            this.mCallbacks.remove(reference);
        }
    }

    private static final class CallbackWeakReference
    extends WeakReference<Drawable.Callback> {
        CallbackWeakReference(Drawable.Callback r) {
            super(r);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.get() == ((CallbackWeakReference)o).get();
        }

        public int hashCode() {
            Drawable.Callback callback = (Drawable.Callback)this.get();
            return callback != null ? callback.hashCode() : 0;
        }
    }
}

