/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.graphics.Bitmap;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import java.io.IOException;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.InputSource;

public class GifDecoder {
    private final GifInfoHandle mGifInfoHandle;

    public GifDecoder(InputSource inputSource) throws IOException {
        this.mGifInfoHandle = inputSource.open();
    }

    public String getComment() {
        return this.mGifInfoHandle.getComment();
    }

    public int getLoopCount() {
        return this.mGifInfoHandle.getLoopCount();
    }

    public long getSourceLength() {
        return this.mGifInfoHandle.getSourceLength();
    }

    public void seekToTime(@IntRange(from=0L, to=0x7FFFFFFFL) int position, @NonNull Bitmap buffer) {
        this.checkBuffer(buffer);
        this.mGifInfoHandle.seekToTime(position, buffer);
    }

    public void seekToFrame(@IntRange(from=0L, to=0x7FFFFFFFL) int frameIndex, @NonNull Bitmap buffer) {
        this.checkBuffer(buffer);
        this.mGifInfoHandle.seekToFrame(frameIndex, buffer);
    }

    public long getAllocationByteCount() {
        return this.mGifInfoHandle.getAllocationByteCount();
    }

    public int getFrameDuration(@IntRange(from=0L) int index) {
        return this.mGifInfoHandle.getFrameDuration(index);
    }

    public int getDuration() {
        return this.mGifInfoHandle.getDuration();
    }

    public int getWidth() {
        return this.mGifInfoHandle.width;
    }

    public int getHeight() {
        return this.mGifInfoHandle.height;
    }

    public int getNumberOfFrames() {
        return this.mGifInfoHandle.frameCount;
    }

    public boolean isAnimated() {
        return this.mGifInfoHandle.frameCount > 1 && this.getDuration() > 0;
    }

    private void checkBuffer(Bitmap buffer) {
        if (buffer.isRecycled()) {
            throw new IllegalArgumentException("Bitmap is recycled");
        }
        if (buffer.getWidth() < this.mGifInfoHandle.width || buffer.getHeight() < this.mGifInfoHandle.height) {
            throw new IllegalArgumentException("Bitmap ia too small, size must be greater than or equal to GIF size");
        }
    }
}

