/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.autoconfigure.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;

public class ProblemHttpConfigurer
extends AbstractHttpConfigurer<ProblemHttpConfigurer, HttpSecurity> {
    private static final Logger log = LoggerFactory.getLogger(ProblemHttpConfigurer.class);

    public void init(HttpSecurity http) {
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        if (applicationContext == null) {
            log.warn("HttpSecurity's SharedObject doesn't have ApplicationContext");
            return;
        }
        ObjectProvider provider = applicationContext.getBeanProvider(SecurityProblemSupport.class);
        provider.ifAvailable(support -> this.register(http, (SecurityProblemSupport)support));
    }

    private void register(HttpSecurity http, SecurityProblemSupport support) {
        try {
            http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)support).accessDeniedHandler((AccessDeniedHandler)support);
        }
        catch (Exception cause) {
            throw new BeanCreationException("Fail to register HttpSecurity's exceptionHandling", (Throwable)cause);
        }
        log.info("Register HttpSecurity's exceptionHandling");
    }
}

