/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.autoconfigure;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apiguardian.api.API;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.zalando.problem.jackson.ProblemModule;
import org.zalando.problem.violations.ConstraintViolationProblemModule;

@API(status=API.Status.INTERNAL)
@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@ConditionalOnBean(value={WebMvcConfigurationSupport.class})
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
public class ProblemJacksonWebMvcAutoConfiguration
implements WebMvcConfigurer {
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        ObjectMapper mapper = Jackson2ObjectMapperBuilder.json().modules(new Module[]{new ProblemModule(), new ConstraintViolationProblemModule()}).build();
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(mapper));
    }
}

