/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.common;

import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.spring.common.MediaTypes;

@API(status=API.Status.INTERNAL)
public final class AdviceTraits {
    private static final Logger LOG = LoggerFactory.getLogger(AdviceTraits.class);

    private AdviceTraits() {
    }

    public static void log(Throwable throwable, HttpStatus status) {
        if (status.is4xxClientError()) {
            LOG.warn("{}: {}", (Object)status.getReasonPhrase(), (Object)throwable.getMessage());
        } else if (status.is5xxServerError()) {
            LOG.error(status.getReasonPhrase(), throwable);
        }
    }

    public static ResponseEntity<Problem> fallback(Problem problem, HttpHeaders headers) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.valueOf((int)Optional.ofNullable(problem.getStatus()).orElse((StatusType)Status.INTERNAL_SERVER_ERROR).getStatusCode())).headers(headers)).contentType(MediaTypes.PROBLEM).body((Object)problem);
    }

    public static Optional<MediaType> getProblemMediaType(List<MediaType> mediaTypes) {
        for (MediaType mediaType : mediaTypes) {
            if (mediaType.includes(MediaType.APPLICATION_JSON) || mediaType.includes(MediaTypes.PROBLEM)) {
                return Optional.of(MediaTypes.PROBLEM);
            }
            if (!mediaType.includes(MediaTypes.X_PROBLEM)) continue;
            return Optional.of(MediaTypes.X_PROBLEM);
        }
        return Optional.empty();
    }
}

