/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring;

import jakarta.annotation.Nullable;
import java.io.IOException;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.spring.BufferingClientHttpResponseWrapper;
import org.zalando.logbook.spring.LocalRequest;
import org.zalando.logbook.spring.RemoteResponse;

@API(status=API.Status.EXPERIMENTAL)
public final class LogbookClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogbookClientHttpRequestInterceptor.class);
    private final Logbook logbook;

    public ClientHttpResponse intercept(org.springframework.http.HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        Logbook.ResponseProcessingStage stage = this.logRequest(request, body);
        BufferingClientHttpResponseWrapper response = new BufferingClientHttpResponseWrapper(execution.execute(request, body));
        LogbookClientHttpRequestInterceptor.logResponse(stage, response);
        return response;
    }

    @Nullable
    private Logbook.ResponseProcessingStage logRequest(org.springframework.http.HttpRequest request, byte[] body) {
        Logbook.ResponseProcessingStage stage = null;
        try {
            LocalRequest httpRequest = new LocalRequest(request, body);
            stage = this.logbook.process((HttpRequest)httpRequest).write();
        }
        catch (Exception e) {
            log.warn("Unable to log request. Will skip the request & response logging step.", (Throwable)e);
        }
        return stage;
    }

    private static void logResponse(@Nullable Logbook.ResponseProcessingStage stage, ClientHttpResponse response) {
        if (stage != null) {
            try {
                RemoteResponse httpResponse = new RemoteResponse(response);
                stage.process((HttpResponse)httpResponse).write();
            }
            catch (Exception e) {
                log.warn("Unable to log response. Will skip the response logging step.", (Throwable)e);
            }
        } else {
            log.warn("Unable to log response: ResponseProcessingStage is null. Will skip the response logging step.");
        }
    }

    @Generated
    public LogbookClientHttpRequestInterceptor(Logbook logbook) {
        this.logbook = logbook;
    }
}

