/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.springframework.http.MediaType;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;

final class LocalRequest
implements HttpRequest {
    private final org.springframework.http.HttpRequest request;
    private final byte[] body;
    private boolean withBody = false;

    public String getRemote() {
        return "localhost";
    }

    public String getMethod() {
        return this.request.getMethod().name();
    }

    public String getScheme() {
        return Optional.of(this.request.getURI()).map(URI::getScheme).orElse("");
    }

    public String getHost() {
        return Optional.of(this.request.getURI()).map(URI::getHost).orElse("");
    }

    public Optional<Integer> getPort() {
        return Optional.of(this.request.getURI().getPort()).filter(p -> p != -1);
    }

    public String getPath() {
        return Optional.of(this.request.getURI()).map(URI::getPath).orElse("");
    }

    public String getQuery() {
        return Optional.of(this.request.getURI()).map(URI::getQuery).orElse("");
    }

    public HttpRequest withBody() throws IOException {
        this.withBody = true;
        return this;
    }

    public HttpRequest withoutBody() {
        this.withBody = false;
        return this;
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public HttpHeaders getHeaders() {
        LinkedHashMap map = new LinkedHashMap();
        this.request.getHeaders().forEach((name, values) -> map.put(name, new ArrayList(values)));
        return HttpHeaders.of(map);
    }

    @Nullable
    public String getContentType() {
        return Optional.ofNullable(this.request.getHeaders().getFirst("Content-Type")).orElse(null);
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.getContentType()).map(ct -> MediaType.parseMediaType((String)ct).getCharset()).orElse(StandardCharsets.UTF_8);
    }

    public byte[] getBody() throws IOException {
        return this.withBody ? this.body : new byte[]{};
    }

    @Generated
    public LocalRequest(org.springframework.http.HttpRequest request, byte[] body) {
        this.request = request;
        this.body = body;
    }
}

