/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apiguardian.api.API;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.zalando.logbook.attributes.AttributeExtractor;
import org.zalando.logbook.core.attributes.JwtAllMatchingClaimsExtractor;
import org.zalando.logbook.core.attributes.JwtAllMatchingClaimsExtractorJackson2;
import org.zalando.logbook.core.attributes.JwtFirstMatchingClaimExtractor;
import org.zalando.logbook.core.attributes.JwtFirstMatchingClaimExtractorJackson2;
import org.zalando.logbook.servlet.FormRequestMode;
import tools.jackson.databind.json.JsonMapper;

@API(status=API.Status.INTERNAL)
@ConfigurationProperties(prefix="logbook")
public final class LogbookProperties {
    private final List<String> include = new ArrayList<String>();
    private final List<String> exclude = new ArrayList<String>();
    private final PredicateProperties predicate = new PredicateProperties();
    private final Obfuscate obfuscate = new Obfuscate();
    private final Write write = new Write();
    private final Filter filter = new Filter();
    private final List<ExtractorProperty> attributeExtractors = new ArrayList<ExtractorProperty>();

    @Generated
    public List<String> getInclude() {
        return this.include;
    }

    @Generated
    public List<String> getExclude() {
        return this.exclude;
    }

    @Generated
    public PredicateProperties getPredicate() {
        return this.predicate;
    }

    @Generated
    public Obfuscate getObfuscate() {
        return this.obfuscate;
    }

    @Generated
    public Write getWrite() {
        return this.write;
    }

    @Generated
    public Filter getFilter() {
        return this.filter;
    }

    @Generated
    public List<ExtractorProperty> getAttributeExtractors() {
        return this.attributeExtractors;
    }

    public static class PredicateProperties {
        private List<LogbookPredicate> include = new ArrayList<LogbookPredicate>();
        private List<LogbookPredicate> exclude = new ArrayList<LogbookPredicate>();

        @Generated
        public List<LogbookPredicate> getInclude() {
            return this.include;
        }

        @Generated
        public List<LogbookPredicate> getExclude() {
            return this.exclude;
        }

        @Generated
        public void setInclude(List<LogbookPredicate> include) {
            this.include = include;
        }

        @Generated
        public void setExclude(List<LogbookPredicate> exclude) {
            this.exclude = exclude;
        }
    }

    public static class Obfuscate {
        private final List<String> headers = new ArrayList<String>();
        private final List<String> parameters = new ArrayList<String>();
        private final List<String> paths = new ArrayList<String>();
        private final List<String> jsonBodyFields = new ArrayList<String>();
        private String replacement = "XXX";

        @Generated
        public List<String> getHeaders() {
            return this.headers;
        }

        @Generated
        public List<String> getParameters() {
            return this.parameters;
        }

        @Generated
        public List<String> getPaths() {
            return this.paths;
        }

        @Generated
        public List<String> getJsonBodyFields() {
            return this.jsonBodyFields;
        }

        @Generated
        public String getReplacement() {
            return this.replacement;
        }

        @Generated
        public void setReplacement(String replacement) {
            this.replacement = replacement;
        }
    }

    public static class Write {
        private int chunkSize;
        private int maxBodySize = -1;

        @Generated
        public int getChunkSize() {
            return this.chunkSize;
        }

        @Generated
        public int getMaxBodySize() {
            return this.maxBodySize;
        }

        @Generated
        public void setChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        @Generated
        public void setMaxBodySize(int maxBodySize) {
            this.maxBodySize = maxBodySize;
        }
    }

    public static class Filter {
        private FormRequestMode formRequestMode = FormRequestMode.fromProperties();

        @Generated
        public FormRequestMode getFormRequestMode() {
            return this.formRequestMode;
        }

        @Generated
        public void setFormRequestMode(FormRequestMode formRequestMode) {
            this.formRequestMode = formRequestMode;
        }
    }

    public static class LogbookPredicate {
        private String path;
        private List<String> methods = new ArrayList<String>();

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public List<String> getMethods() {
            return this.methods;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }

        @Generated
        public void setMethods(List<String> methods) {
            this.methods = methods;
        }
    }

    @Generated
    public static class ExtractorProperty {
        @Nonnull
        private String type;
        @Nullable
        private List<String> claimNames;
        @Nullable
        private String claimKey;

        public AttributeExtractor toExtractor(Object mapper) {
            boolean isJackson3 = mapper.getClass().getName().startsWith("tools.jackson.");
            switch (this.type) {
                case "JwtFirstMatchingClaimExtractor": {
                    if (isJackson3) {
                        return JwtFirstMatchingClaimExtractor.builder().jsonMapper((JsonMapper)mapper).claimNames(this.claimNames).claimKey(this.claimKey).build();
                    }
                    return JwtFirstMatchingClaimExtractorJackson2.builder().objectMapper((ObjectMapper)mapper).claimNames(this.claimNames).claimKey(this.claimKey).build();
                }
                case "JwtAllMatchingClaimsExtractor": {
                    if (isJackson3) {
                        return JwtAllMatchingClaimsExtractor.builder().jsonMapper((JsonMapper)mapper).claimNames(this.claimNames).build();
                    }
                    return JwtAllMatchingClaimsExtractorJackson2.builder().objectMapper((ObjectMapper)mapper).claimNames(this.claimNames).build();
                }
            }
            throw new IllegalArgumentException("Unknown AttributeExtractor type: " + this.type);
        }

        @Nonnull
        @Generated
        public String getType() {
            return this.type;
        }

        @Nullable
        @Generated
        public List<String> getClaimNames() {
            return this.claimNames;
        }

        @Nullable
        @Generated
        public String getClaimKey() {
            return this.claimKey;
        }

        @Generated
        public void setType(@Nonnull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        @Generated
        public void setClaimNames(@Nullable List<String> claimNames) {
            this.claimNames = claimNames;
        }

        @Generated
        public void setClaimKey(@Nullable String claimKey) {
            this.claimKey = claimKey;
        }
    }
}

