/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.ContentType;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.common.MediaTypeQuery;
import org.zalando.logbook.servlet.ByteStreams;
import org.zalando.logbook.servlet.FormRequestMode;
import org.zalando.logbook.servlet.ServletInputStreamAdapter;

final class RemoteRequest
extends HttpServletRequestWrapper
implements HttpRequest {
    private final AtomicReference<State> state;
    private Optional<AsyncListener> asyncListener = Optional.empty();

    private static State doBuffer(ServletRequest request, FormRequestMode formRequestMode, Charset charset) throws IOException {
        if (RemoteRequest.isFormRequest(request)) {
            switch (formRequestMode) {
                case PARAMETER: {
                    return new Buffering(RemoteRequest.reconstructFormBody(request, charset));
                }
                case OFF: {
                    return new Passing();
                }
            }
        }
        if (RemoteRequest.isMultipartRequest(request)) {
            return new Passing();
        }
        return new Buffering(ByteStreams.toByteArray((InputStream)request.getInputStream()));
    }

    private static boolean isFormRequest(ServletRequest request) {
        Predicate FORM_REQUEST = MediaTypeQuery.compile((String)"application/x-www-form-urlencoded", (String[])new String[0]);
        return Optional.ofNullable(request.getContentType()).filter(FORM_REQUEST).isPresent();
    }

    private static boolean isMultipartRequest(ServletRequest request) {
        Predicate FORM_REQUEST = MediaTypeQuery.compile((String)"multipart/*", (String[])new String[0]);
        return Optional.ofNullable(request.getContentType()).filter(FORM_REQUEST).isPresent();
    }

    private static byte[] reconstructFormBody(ServletRequest request, Charset charset) {
        return request.getParameterMap().entrySet().stream().flatMap(entry -> Arrays.stream((String[])entry.getValue()).map(value -> RemoteRequest.encode((String)entry.getKey(), "UTF-8") + "=" + RemoteRequest.encode(value, "UTF-8"))).collect(Collectors.joining("&")).getBytes(charset);
    }

    RemoteRequest(HttpServletRequest request, FormRequestMode formRequestMode) {
        super(request);
        this.state = new AtomicReference<Unbuffered>(new Unbuffered(formRequestMode, this.getCharset()));
    }

    public String getProtocolVersion() {
        return this.getProtocol();
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public String getRemote() {
        return this.getRemoteAddr();
    }

    public String getHost() {
        return this.getServerName();
    }

    public Optional<Integer> getPort() {
        return Optional.of(this.getServerPort());
    }

    public String getPath() {
        return this.getRequestURI();
    }

    public String getQuery() {
        return Optional.ofNullable(this.getQueryString()).orElse("");
    }

    public HttpHeaders getHeaders() {
        HttpHeaders headers = HttpHeaders.empty();
        Enumeration names = this.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            headers = headers.update(name, Collections.list(this.getHeaders(name)));
        }
        return headers;
    }

    public Charset getCharset() {
        String contentTypeHeader = this.getHeaders().getFirst("Content-Type");
        return Optional.ofNullable(contentTypeHeader).map(ContentType::parseCharset).orElse(StandardCharsets.ISO_8859_1);
    }

    public HttpRequest withBody() {
        this.state.updateAndGet(State::with);
        this.buffer();
        return this;
    }

    public HttpRequest withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.buffer().getInputStream(this.getRequest());
    }

    public BufferedReader getReader() throws IOException {
        ServletInputStream stream = this.getInputStream();
        InputStreamReader reader = new InputStreamReader((InputStream)stream, this.getCharset());
        return new BufferedReader(reader);
    }

    public byte[] getBody() {
        return this.buffer().getBody();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        AsyncContext asyncContext = super.startAsync();
        this.asyncListener.ifPresent(arg_0 -> ((AsyncContext)asyncContext).addListener(arg_0));
        return asyncContext;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        AsyncContext asyncContext = super.startAsync(servletRequest, servletResponse);
        this.asyncListener.ifPresent(arg_0 -> ((AsyncContext)asyncContext).addListener(arg_0));
        return asyncContext;
    }

    public void setAsyncListener(Optional<AsyncListener> asyncListener) {
        this.asyncListener = asyncListener;
    }

    private State buffer() {
        return this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(state -> state.buffer(this.getRequest())));
    }

    static String encode(String s, String charset) {
        return URLEncoder.encode(s, charset);
    }

    private static final class Buffering
    extends WithBody {
        Buffering(byte[] body) {
            this(body, new ByteArrayInputStream(body));
        }

        Buffering(byte[] body, ByteArrayInputStream stream) {
            super(body, stream);
        }

        @Override
        public ServletInputStream getInputStream(ServletRequest request) {
            return new ServletInputStreamAdapter(new ByteArrayInputStream(this.body));
        }

        @Override
        public State without() {
            return new Ignoring(this.body);
        }
    }

    private static final class Passing
    implements State {
        private Passing() {
        }
    }

    private static final class Unbuffered
    implements State {
        private final FormRequestMode formRequestMode;
        private final Charset charset;

        @Override
        public State with() {
            return new Offering(this.formRequestMode, this.charset);
        }

        @Override
        public State without() {
            return new Withouted(this.formRequestMode, this.charset);
        }

        @Override
        public State buffer(ServletRequest request) throws IOException {
            return RemoteRequest.doBuffer(request, this.formRequestMode, this.charset);
        }

        @Generated
        public Unbuffered(FormRequestMode formRequestMode, Charset charset) {
            this.formRequestMode = formRequestMode;
            this.charset = charset;
        }
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(ServletRequest request) throws IOException {
            return this;
        }

        default public ServletInputStream getInputStream(ServletRequest request) throws IOException {
            return request.getInputStream();
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }

    private static final class Ignoring
    extends WithBody {
        Ignoring(byte[] body) {
            super(body, new ByteArrayInputStream(body));
        }

        @Override
        public ServletInputStream getInputStream(ServletRequest request) {
            return new ServletInputStreamAdapter(new ByteArrayInputStream(new byte[0]));
        }

        @Override
        public byte[] getBody() {
            return new byte[0];
        }

        @Override
        public State with() {
            return new Buffering(this.body, this.getStream());
        }
    }

    private static abstract class WithBody
    extends Streaming {
        protected final byte[] body;

        protected WithBody(byte[] body, ByteArrayInputStream stream) {
            super(stream);
            this.body = body;
        }

        @Override
        public byte[] getBody() {
            return this.body;
        }
    }

    private static abstract class Streaming
    implements State {
        private final ByteArrayInputStream stream;

        @Generated
        public Streaming(ByteArrayInputStream stream) {
            this.stream = stream;
        }

        @Generated
        protected ByteArrayInputStream getStream() {
            return this.stream;
        }
    }

    private static final class Offering
    implements State {
        private final FormRequestMode formRequestMode;
        private final Charset charset;

        @Override
        public State buffer(ServletRequest request) throws IOException {
            return RemoteRequest.doBuffer(request, this.formRequestMode, this.charset);
        }

        @Generated
        public Offering(FormRequestMode formRequestMode, Charset charset) {
            this.formRequestMode = formRequestMode;
            this.charset = charset;
        }
    }

    private static final class Withouted
    implements State {
        private final FormRequestMode formRequestMode;
        private final Charset charset;

        @Override
        public State with() {
            return new Offering(this.formRequestMode, this.charset);
        }

        @Generated
        public Withouted(FormRequestMode formRequestMode, Charset charset) {
            this.formRequestMode = formRequestMode;
            this.charset = charset;
        }
    }
}

