/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.ContentType;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.json.JsonFieldWriter;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.json.JsonFactory;
import tools.jackson.databind.json.JsonMapper;

@API(status=API.Status.STABLE)
public final class FastJsonHttpLogFormatter
implements HttpLogFormatter {
    private final JsonFactory factory;
    private final JsonFieldWriter delegate;

    public FastJsonHttpLogFormatter() {
        this(new JsonMapper());
    }

    public FastJsonHttpLogFormatter(JsonMapper mapper) {
        this(mapper, (JsonFieldWriter)new DefaultJsonFieldWriter());
    }

    public FastJsonHttpLogFormatter(JsonMapper mapper, JsonFieldWriter writer) {
        this(mapper.tokenStreamFactory(), writer);
    }

    public String format(Precorrelation precorrelation, HttpRequest request) throws IOException {
        return this.format(precorrelation, request, this.delegate::write);
    }

    public String format(Correlation correlation, HttpResponse response) throws IOException {
        return this.format(correlation, response, this.delegate::write);
    }

    private <C extends Precorrelation, H extends HttpMessage> String format(C correlation, H message, Formatter<C, H> formatter) throws IOException {
        StringWriter writer = new StringWriter(message.getBody().length + 2048);
        try (JsonGenerator generator = this.factory.createGenerator(ObjectWriteContext.empty(), (Writer)writer);){
            generator.writeStartObject();
            formatter.format(correlation, message, generator);
            this.delegate.write(message, generator);
            generator.writeEndObject();
        }
        return writer.toString();
    }

    @Generated
    public FastJsonHttpLogFormatter(JsonFactory factory, JsonFieldWriter delegate) {
        this.factory = factory;
        this.delegate = delegate;
    }

    private static class DefaultJsonFieldWriter
    implements JsonFieldWriter {
        private DefaultJsonFieldWriter() {
        }

        @Override
        public <M extends HttpMessage> void write(M message, JsonGenerator generator) throws IOException {
            this.writeHeaders(message, generator);
            this.writeBody(message, generator);
        }

        private void writeHeaders(HttpMessage message, JsonGenerator generator) {
            HttpHeaders headers = message.getHeaders();
            if (headers.isEmpty()) {
                return;
            }
            generator.writeName("headers");
            generator.writeStartObject();
            for (Map.Entry entry : headers.entrySet()) {
                generator.writeName((String)entry.getKey());
                generator.writeStartArray();
                for (String value : (List)entry.getValue()) {
                    generator.writeString(value);
                }
                generator.writeEndArray();
            }
            generator.writeEndObject();
        }

        private void writeBody(HttpMessage message, JsonGenerator generator) throws IOException {
            String body = message.getBodyAsString();
            if (body.isEmpty()) {
                return;
            }
            generator.writeName("body");
            String contentType = message.getContentType();
            if (ContentType.isJsonMediaType((String)contentType)) {
                generator.writeRawValue(body);
            } else {
                generator.writeString(body);
            }
        }
    }

    @FunctionalInterface
    private static interface Formatter<C extends Precorrelation, H extends HttpMessage> {
        public void format(C var1, H var2, JsonGenerator var3) throws IOException;
    }
}

