/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import jakarta.annotation.Nullable;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.ContentType;
import org.zalando.logbook.json.JsonCompactor;
import org.zalando.logbook.json.JsonGeneratorWrapper;
import org.zalando.logbook.json.NoopJsonCompactor;
import org.zalando.logbook.json.ParsingJsonCompactor;

@API(status=API.Status.MAINTAINED)
public final class CompactingJsonBodyFilter
implements BodyFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompactingJsonBodyFilter.class);
    private final JsonCompactor compactor;

    public CompactingJsonBodyFilter(JsonGeneratorWrapper jsonGeneratorWrapper) {
        this(new ParsingJsonCompactor(jsonGeneratorWrapper));
    }

    @Generated
    public CompactingJsonBodyFilter() {
        this(CompactingJsonBodyFilter.createDefaultCompactor());
    }

    @Generated
    private static JsonCompactor createDefaultCompactor() {
        try {
            Class.forName("tools.jackson.core.json.JsonFactory");
            return new ParsingJsonCompactor();
        }
        catch (ClassNotFoundException e) {
            return new NoopJsonCompactor();
        }
    }

    public String filter(@Nullable String contentType, String body) {
        if (!ContentType.isJsonMediaType((String)contentType)) {
            return body;
        }
        try {
            return this.compactor.compact(body);
        }
        catch (RuntimeException e) {
            log.trace("Unable to compact body, is it a JSON?. Keep it as-is: `{}`", (Object)e.getMessage());
            return body;
        }
    }

    @Generated
    public CompactingJsonBodyFilter(JsonCompactor compactor) {
        this.compactor = compactor;
    }
}

