/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.ContentType;

@Deprecated(since="4.0.0", forRemoval=true)
final class PrimitiveJsonPropertyBodyFilterJackson2
implements BodyFilter {
    private static final String BOOLEAN_PATTERN = "(?>true|false)";
    private static final String NUMBER_PATTERN = "(?>-?(?>0|[1-9][0-9]*)(?>\\.[0-9]+)?(?>[eE][+-]?[0-9]+)?)";
    private static final Pattern NUMBER = PrimitiveJsonPropertyBodyFilterJackson2.pattern("(?>-?(?>0|[1-9][0-9]*)(?>\\.[0-9]+)?(?>[eE][+-]?[0-9]+)?)");
    private static final String STRING_VALUE_PATTERN = "(?>(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)++|)";
    private static final String STRING_PATTERN = "(?>\"(?>(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)++|)\")";
    private static final Pattern STRING = PrimitiveJsonPropertyBodyFilterJackson2.pattern("(?>\"(?>(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)++|)\")");
    private static final String PRIMITIVE_PATTERN = "(?>(?>true|false)|(?>-?(?>0|[1-9][0-9]*)(?>\\.[0-9]+)?(?>[eE][+-]?[0-9]+)?)|(?>\"(?>(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)++|)\"))";
    private static final Pattern PRIMITIVE = PrimitiveJsonPropertyBodyFilterJackson2.pattern("(?>(?>true|false)|(?>-?(?>0|[1-9][0-9]*)(?>\\.[0-9]+)?(?>[eE][+-]?[0-9]+)?)|(?>\"(?>(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)++|)\"))");
    private final Pattern pattern;
    private final Predicate<String> predicate;
    private final BiFunction<String, String, String> replacement;

    private static Pattern pattern(String value) {
        return Pattern.compile("(?<key>\"(?<property>(?>(?>\\\\(?>[\"\\\\/bfnrt]|u[a-fA-F0-9]{4})|[^\"\\\\\u0000-\\x1F\\x7F]+)++|))\"\\s*:\\s*)(?<propertyValue>" + value + "|null)");
    }

    public String filter(@Nullable String contentType, String body) {
        if (ContentType.isJsonMediaType((String)contentType)) {
            Matcher matcher = this.pattern.matcher(body);
            StringBuffer result = new StringBuffer(body.length());
            while (matcher.find()) {
                if (this.predicate.test(matcher.group("property"))) {
                    matcher.appendReplacement(result, "${key}");
                    result.append(this.replacement.apply(matcher.group("property"), matcher.group("propertyValue")));
                    continue;
                }
                matcher.appendReplacement(result, "$0");
            }
            matcher.appendTail(result);
            return result.toString();
        }
        return body;
    }

    public BodyFilter tryMerge(BodyFilter next) {
        PrimitiveJsonPropertyBodyFilterJackson2 filter;
        if (next instanceof PrimitiveJsonPropertyBodyFilterJackson2 && this.compatibleWith(filter = (PrimitiveJsonPropertyBodyFilterJackson2)next)) {
            return this.withPredicate(this.predicate.or(filter.predicate));
        }
        return null;
    }

    private boolean compatibleWith(PrimitiveJsonPropertyBodyFilterJackson2 that) {
        return this.pattern.equals(that.pattern) && this.replacement.equals(that.replacement);
    }

    static BodyFilter replaceString(Predicate<String> predicate, String replacement) {
        return PrimitiveJsonPropertyBodyFilterJackson2.create(STRING, predicate, new StaticReplacement(replacement).andThen(PrimitiveJsonPropertyBodyFilterJackson2.quote()));
    }

    static BodyFilter replaceNumber(Predicate<String> predicate, Number replacement) {
        return PrimitiveJsonPropertyBodyFilterJackson2.create(NUMBER, predicate, new StaticReplacement(replacement.toString()));
    }

    static BodyFilter replacePrimitive(Predicate<String> predicate, String replacement) {
        return PrimitiveJsonPropertyBodyFilterJackson2.create(PRIMITIVE, predicate, new StaticReplacement(replacement).andThen(PrimitiveJsonPropertyBodyFilterJackson2.quote()));
    }

    static BodyFilter replacePrimitive(Predicate<String> predicate, BiFunction<String, String, String> replacement) {
        return PrimitiveJsonPropertyBodyFilterJackson2.create(PRIMITIVE, predicate, new DynamicReplacement(replacement).andThen(PrimitiveJsonPropertyBodyFilterJackson2.quote()));
    }

    private static UnaryOperator<String> quote() {
        return Quote.INSTANCE;
    }

    @Generated
    private PrimitiveJsonPropertyBodyFilterJackson2(Pattern pattern, Predicate<String> predicate, BiFunction<String, String, String> replacement) {
        this.pattern = pattern;
        this.predicate = predicate;
        this.replacement = replacement;
    }

    @Generated
    private static PrimitiveJsonPropertyBodyFilterJackson2 create(Pattern pattern, Predicate<String> predicate, BiFunction<String, String, String> replacement) {
        return new PrimitiveJsonPropertyBodyFilterJackson2(pattern, predicate, replacement);
    }

    @Generated
    private PrimitiveJsonPropertyBodyFilterJackson2 withPredicate(Predicate<String> predicate) {
        return this.predicate == predicate ? this : new PrimitiveJsonPropertyBodyFilterJackson2(this.pattern, predicate, this.replacement);
    }

    private static final class StaticReplacement
    implements ProperBiFunction<String, String, String> {
        private final String replacement;

        @Override
        public String apply(String name, String value) {
            return this.replacement;
        }

        @Generated
        public StaticReplacement(String replacement) {
            this.replacement = replacement;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StaticReplacement)) {
                return false;
            }
            StaticReplacement other = (StaticReplacement)o;
            String this$replacement = this.replacement;
            String other$replacement = other.replacement;
            return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $replacement = this.replacement;
            result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
            return result;
        }
    }

    private static final class DynamicReplacement
    implements ProperBiFunction<String, String, String> {
        private final BiFunction<String, String, String> replacement;

        @Override
        public String apply(String name, String value) {
            return this.replacement.apply(name, value);
        }

        @Generated
        public DynamicReplacement(BiFunction<String, String, String> replacement) {
            this.replacement = replacement;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DynamicReplacement)) {
                return false;
            }
            DynamicReplacement other = (DynamicReplacement)o;
            BiFunction<String, String, String> this$replacement = this.replacement;
            BiFunction<String, String, String> other$replacement = other.replacement;
            return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BiFunction<String, String, String> $replacement = this.replacement;
            result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
            return result;
        }
    }

    private static enum Quote implements UnaryOperator<String>
    {
        INSTANCE;


        @Override
        public String apply(String s) {
            return "\"" + s + "\"";
        }
    }

    private static interface ProperBiFunction<T, U, R>
    extends BiFunction<T, U, R> {
        @Override
        @Nonnull
        default public <V> BiFunction<T, U, V> andThen(Function<? super R, ? extends V> after) {
            return new After(this, after);
        }

        public static final class After<T, U, R, V>
        implements ProperBiFunction<T, U, V> {
            private final BiFunction<T, U, R> before;
            private final Function<? super R, ? extends V> after;

            @Override
            public V apply(T t, U u) {
                return this.after.apply(this.before.apply(t, u));
            }

            @Generated
            public After(BiFunction<T, U, R> before, Function<? super R, ? extends V> after) {
                this.before = before;
                this.after = after;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof After)) {
                    return false;
                }
                After other = (After)o;
                BiFunction<T, U, R> this$before = this.before;
                BiFunction<T, U, R> other$before = other.before;
                if (this$before == null ? other$before != null : !this$before.equals(other$before)) {
                    return false;
                }
                Function<R, V> this$after = this.after;
                Function<? super R, ? extends V> other$after = other.after;
                return !(this$after == null ? other$after != null : !this$after.equals(other$after));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BiFunction<T, U, R> $before = this.before;
                result = result * 59 + ($before == null ? 43 : $before.hashCode());
                Function<R, V> $after = this.after;
                result = result * 59 + ($after == null ? 43 : $after.hashCode());
                return result;
            }
        }
    }
}

