/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.ContentType;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.json.JsonFieldWriterJackson2;

@API(status=API.Status.STABLE)
@Deprecated(since="4.0.0", forRemoval=true)
public final class FastJsonHttpLogFormatterJackson2
implements HttpLogFormatter {
    private final JsonFactory factory;
    private final JsonFieldWriterJackson2 delegate;

    public FastJsonHttpLogFormatterJackson2() {
        this(new ObjectMapper());
    }

    public FastJsonHttpLogFormatterJackson2(ObjectMapper mapper) {
        this(mapper, (JsonFieldWriterJackson2)new DefaultJsonFieldWriter());
    }

    public FastJsonHttpLogFormatterJackson2(ObjectMapper mapper, JsonFieldWriterJackson2 writer) {
        this(mapper.getFactory(), writer);
    }

    public String format(Precorrelation precorrelation, HttpRequest request) throws IOException {
        return this.format(precorrelation, request, this.delegate::write);
    }

    public String format(Correlation correlation, HttpResponse response) throws IOException {
        return this.format(correlation, response, this.delegate::write);
    }

    private <C extends Precorrelation, H extends HttpMessage> String format(C correlation, H message, Formatter<C, H> formatter) throws IOException {
        StringWriter writer = new StringWriter(message.getBody().length + 2048);
        try (JsonGenerator generator = this.factory.createGenerator((Writer)writer);){
            generator.writeStartObject();
            formatter.format(correlation, message, generator);
            this.delegate.write(message, generator);
            generator.writeEndObject();
        }
        return writer.toString();
    }

    @Generated
    public FastJsonHttpLogFormatterJackson2(JsonFactory factory, JsonFieldWriterJackson2 delegate) {
        this.factory = factory;
        this.delegate = delegate;
    }

    private static class DefaultJsonFieldWriter
    implements JsonFieldWriterJackson2 {
        private DefaultJsonFieldWriter() {
        }

        @Override
        public <M extends HttpMessage> void write(M message, JsonGenerator generator) throws IOException {
            this.writeHeaders(message, generator);
            this.writeBody(message, generator);
        }

        private void writeHeaders(HttpMessage message, JsonGenerator generator) throws IOException {
            HttpHeaders headers = message.getHeaders();
            if (headers.isEmpty()) {
                return;
            }
            generator.writeObjectField("headers", (Object)headers);
        }

        private void writeBody(HttpMessage message, JsonGenerator generator) throws IOException {
            String body = message.getBodyAsString();
            if (body.isEmpty()) {
                return;
            }
            generator.writeFieldName("body");
            String contentType = message.getContentType();
            if (ContentType.isJsonMediaType((String)contentType)) {
                generator.writeRawValue(body);
            } else {
                generator.writeString(body);
            }
        }
    }

    @FunctionalInterface
    private static interface Formatter<C extends Precorrelation, H extends HttpMessage> {
        public void format(C var1, H var2, JsonGenerator var3) throws IOException;
    }
}

