/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import jakarta.annotation.Nullable;
import java.io.IOException;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.ContentType;
import org.zalando.logbook.json.JsonCompactorJackson2;
import org.zalando.logbook.json.JsonGeneratorWrapperJackson2;
import org.zalando.logbook.json.NoopJsonCompactorJackson2;
import org.zalando.logbook.json.ParsingJsonCompactorJackson2;

@Deprecated(since="4.0.0", forRemoval=true)
@API(status=API.Status.MAINTAINED)
public final class CompactingJsonBodyFilterJackson2
implements BodyFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompactingJsonBodyFilterJackson2.class);
    private final JsonCompactorJackson2 compactor;

    public CompactingJsonBodyFilterJackson2(JsonGeneratorWrapperJackson2 jsonGeneratorWrapper) {
        this(new ParsingJsonCompactorJackson2(jsonGeneratorWrapper));
    }

    @Generated
    public CompactingJsonBodyFilterJackson2() {
        this(CompactingJsonBodyFilterJackson2.createDefaultCompactor());
    }

    @Generated
    private static JsonCompactorJackson2 createDefaultCompactor() {
        try {
            Class.forName("com.fasterxml.jackson.core.JsonFactory");
            return new ParsingJsonCompactorJackson2();
        }
        catch (ClassNotFoundException e) {
            return new NoopJsonCompactorJackson2();
        }
    }

    public String filter(@Nullable String contentType, String body) {
        if (!ContentType.isJsonMediaType((String)contentType)) {
            return body;
        }
        try {
            return this.compactor.compact(body);
        }
        catch (IOException e) {
            log.trace("Unable to compact body, is it a JSON?. Keep it as-is: `{}`", (Object)e.getMessage());
            return body;
        }
    }

    @Generated
    public CompactingJsonBodyFilterJackson2(JsonCompactorJackson2 compactor) {
        this.compactor = compactor;
    }
}

