/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core.attributes;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.attributes.AttributeExtractor;
import org.zalando.logbook.attributes.HttpAttributes;
import org.zalando.logbook.core.attributes.JwtClaimsExtractorJackson2;

@API(status=API.Status.EXPERIMENTAL)
@Deprecated(since="4.0.0", forRemoval=true)
public final class JwtFirstMatchingClaimExtractorJackson2
implements AttributeExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtFirstMatchingClaimExtractorJackson2.class);
    private static final String DEFAULT_SUBJECT_CLAIM = "sub";
    private static final String DEFAULT_CLAIM_KEY = "subject";
    private final List<String> claimNames;
    private final JwtClaimsExtractorJackson2 jwtClaimsExtractorJackson2;
    @Nonnull
    private final String claimKey;

    public JwtFirstMatchingClaimExtractorJackson2(@Nonnull ObjectMapper objectMapper, @Nonnull List<String> claimNames, @Nonnull String claimKey) {
        this.claimNames = claimNames;
        this.claimKey = claimKey;
        this.jwtClaimsExtractorJackson2 = new JwtClaimsExtractorJackson2(objectMapper, new ArrayList<String>(claimNames));
    }

    @Nonnull
    private static JwtFirstMatchingClaimExtractorJackson2 create(@Nullable ObjectMapper objectMapper, @Nullable List<String> claimNames, @Nullable String claimKey) {
        return new JwtFirstMatchingClaimExtractorJackson2(Optional.ofNullable(objectMapper).orElse(new ObjectMapper()), Optional.ofNullable(claimNames).orElse(Collections.singletonList(DEFAULT_SUBJECT_CLAIM)), Optional.ofNullable(claimKey).orElse(DEFAULT_CLAIM_KEY));
    }

    @Nonnull
    public HttpAttributes extract(HttpRequest request) {
        try {
            return this.claimNames.stream().map(this.jwtClaimsExtractorJackson2.extractClaims(request)::get).filter(Objects::nonNull).findFirst().map(value -> HttpAttributes.of((String)this.claimKey, (Object)this.jwtClaimsExtractorJackson2.toStringValue(value))).orElse(HttpAttributes.EMPTY);
        }
        catch (Exception e) {
            log.trace("Encountered error while extracting attributes: `{}`", (Object)Optional.ofNullable(e.getCause()).orElse(e).getMessage());
            return HttpAttributes.EMPTY;
        }
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtFirstMatchingClaimExtractorJackson2)) {
            return false;
        }
        JwtFirstMatchingClaimExtractorJackson2 other = (JwtFirstMatchingClaimExtractorJackson2)o;
        List<String> this$claimNames = this.claimNames;
        List<String> other$claimNames = other.claimNames;
        if (this$claimNames == null ? other$claimNames != null : !((Object)this$claimNames).equals(other$claimNames)) {
            return false;
        }
        JwtClaimsExtractorJackson2 this$jwtClaimsExtractorJackson2 = this.jwtClaimsExtractorJackson2;
        JwtClaimsExtractorJackson2 other$jwtClaimsExtractorJackson2 = other.jwtClaimsExtractorJackson2;
        if (this$jwtClaimsExtractorJackson2 == null ? other$jwtClaimsExtractorJackson2 != null : !((Object)this$jwtClaimsExtractorJackson2).equals(other$jwtClaimsExtractorJackson2)) {
            return false;
        }
        String this$claimKey = this.claimKey;
        String other$claimKey = other.claimKey;
        return !(this$claimKey == null ? other$claimKey != null : !this$claimKey.equals(other$claimKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $claimNames = this.claimNames;
        result = result * 59 + ($claimNames == null ? 43 : ((Object)$claimNames).hashCode());
        JwtClaimsExtractorJackson2 $jwtClaimsExtractorJackson2 = this.jwtClaimsExtractorJackson2;
        result = result * 59 + ($jwtClaimsExtractorJackson2 == null ? 43 : ((Object)$jwtClaimsExtractorJackson2).hashCode());
        String $claimKey = this.claimKey;
        result = result * 59 + ($claimKey == null ? 43 : $claimKey.hashCode());
        return result;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static final class Builder {
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private List<String> claimNames;
        @Generated
        private String claimKey;

        @Generated
        Builder() {
        }

        @Generated
        public Builder objectMapper(@Nullable ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public Builder claimNames(@Nullable List<String> claimNames) {
            this.claimNames = claimNames;
            return this;
        }

        @Generated
        public Builder claimKey(@Nullable String claimKey) {
            this.claimKey = claimKey;
            return this;
        }

        @Generated
        public JwtFirstMatchingClaimExtractorJackson2 build() {
            return JwtFirstMatchingClaimExtractorJackson2.create(this.objectMapper, this.claimNames, this.claimKey);
        }

        @Generated
        public String toString() {
            return "JwtFirstMatchingClaimExtractorJackson2.Builder(objectMapper=" + String.valueOf(this.objectMapper) + ", claimNames=" + String.valueOf(this.claimNames) + ", claimKey=" + this.claimKey + ")";
        }
    }
}

