/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core.attributes;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.attributes.AttributeExtractor;
import org.zalando.logbook.attributes.HttpAttributes;
import org.zalando.logbook.core.attributes.JwtClaimsExtractor;
import tools.jackson.databind.json.JsonMapper;

@API(status=API.Status.EXPERIMENTAL)
public final class JwtFirstMatchingClaimExtractor
implements AttributeExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtFirstMatchingClaimExtractor.class);
    private static final String DEFAULT_SUBJECT_CLAIM = "sub";
    private static final String DEFAULT_CLAIM_KEY = "subject";
    private final List<String> claimNames;
    private final JwtClaimsExtractor jwtClaimsExtractor;
    @Nonnull
    private final String claimKey;

    public JwtFirstMatchingClaimExtractor(@Nonnull JsonMapper jsonMapper, @Nonnull List<String> claimNames, @Nonnull String claimKey) {
        this.claimNames = claimNames;
        this.claimKey = claimKey;
        this.jwtClaimsExtractor = new JwtClaimsExtractor(jsonMapper, new ArrayList<String>(claimNames));
    }

    @Nonnull
    private static JwtFirstMatchingClaimExtractor create(@Nullable JsonMapper jsonMapper, @Nullable List<String> claimNames, @Nullable String claimKey) {
        return new JwtFirstMatchingClaimExtractor(Optional.ofNullable(jsonMapper).orElse(new JsonMapper()), Optional.ofNullable(claimNames).orElse(Collections.singletonList(DEFAULT_SUBJECT_CLAIM)), Optional.ofNullable(claimKey).orElse(DEFAULT_CLAIM_KEY));
    }

    @Nonnull
    public HttpAttributes extract(HttpRequest request) {
        try {
            return this.claimNames.stream().map(this.jwtClaimsExtractor.extractClaims(request)::get).filter(Objects::nonNull).findFirst().map(value -> HttpAttributes.of((String)this.claimKey, (Object)this.jwtClaimsExtractor.toStringValue(value))).orElse(HttpAttributes.EMPTY);
        }
        catch (Exception e) {
            log.trace("Encountered error while extracting attributes: `{}`", (Object)Optional.ofNullable(e.getCause()).orElse(e).getMessage());
            return HttpAttributes.EMPTY;
        }
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtFirstMatchingClaimExtractor)) {
            return false;
        }
        JwtFirstMatchingClaimExtractor other = (JwtFirstMatchingClaimExtractor)o;
        List<String> this$claimNames = this.claimNames;
        List<String> other$claimNames = other.claimNames;
        if (this$claimNames == null ? other$claimNames != null : !((Object)this$claimNames).equals(other$claimNames)) {
            return false;
        }
        JwtClaimsExtractor this$jwtClaimsExtractor = this.jwtClaimsExtractor;
        JwtClaimsExtractor other$jwtClaimsExtractor = other.jwtClaimsExtractor;
        if (this$jwtClaimsExtractor == null ? other$jwtClaimsExtractor != null : !((Object)this$jwtClaimsExtractor).equals(other$jwtClaimsExtractor)) {
            return false;
        }
        String this$claimKey = this.claimKey;
        String other$claimKey = other.claimKey;
        return !(this$claimKey == null ? other$claimKey != null : !this$claimKey.equals(other$claimKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $claimNames = this.claimNames;
        result = result * 59 + ($claimNames == null ? 43 : ((Object)$claimNames).hashCode());
        JwtClaimsExtractor $jwtClaimsExtractor = this.jwtClaimsExtractor;
        result = result * 59 + ($jwtClaimsExtractor == null ? 43 : ((Object)$jwtClaimsExtractor).hashCode());
        String $claimKey = this.claimKey;
        result = result * 59 + ($claimKey == null ? 43 : $claimKey.hashCode());
        return result;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static final class Builder {
        @Generated
        private JsonMapper jsonMapper;
        @Generated
        private List<String> claimNames;
        @Generated
        private String claimKey;

        @Generated
        Builder() {
        }

        @Generated
        public Builder jsonMapper(@Nullable JsonMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
            return this;
        }

        @Generated
        public Builder claimNames(@Nullable List<String> claimNames) {
            this.claimNames = claimNames;
            return this;
        }

        @Generated
        public Builder claimKey(@Nullable String claimKey) {
            this.claimKey = claimKey;
            return this;
        }

        @Generated
        public JwtFirstMatchingClaimExtractor build() {
            return JwtFirstMatchingClaimExtractor.create(this.jsonMapper, this.claimNames, this.claimKey);
        }

        @Generated
        public String toString() {
            return "JwtFirstMatchingClaimExtractor.Builder(jsonMapper=" + String.valueOf(this.jsonMapper) + ", claimNames=" + String.valueOf(this.claimNames) + ", claimKey=" + this.claimKey + ")";
        }
    }
}

