/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core.attributes;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.attributes.AttributeExtractor;
import org.zalando.logbook.attributes.HttpAttributes;
import org.zalando.logbook.core.attributes.JwtClaimsExtractorJackson2;

@API(status=API.Status.EXPERIMENTAL)
@Deprecated(since="4.0.0", forRemoval=true)
public final class JwtAllMatchingClaimsExtractorJackson2
implements AttributeExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtAllMatchingClaimsExtractorJackson2.class);
    private static final String DEFAULT_SUBJECT_CLAIM = "sub";
    private final List<String> claimNames;
    private final JwtClaimsExtractorJackson2 jwtClaimsExtractorJackson2;

    public JwtAllMatchingClaimsExtractorJackson2(ObjectMapper objectMapper, List<String> claimNames) {
        this.claimNames = claimNames;
        this.jwtClaimsExtractorJackson2 = new JwtClaimsExtractorJackson2(objectMapper, new ArrayList<String>(claimNames));
    }

    @Nonnull
    private static JwtAllMatchingClaimsExtractorJackson2 create(@Nullable ObjectMapper objectMapper, @Nullable List<String> claimNames) {
        return new JwtAllMatchingClaimsExtractorJackson2(Optional.ofNullable(objectMapper).orElse(new ObjectMapper()), Optional.ofNullable(claimNames).orElse(Collections.singletonList(DEFAULT_SUBJECT_CLAIM)));
    }

    @Nonnull
    public HttpAttributes extract(HttpRequest request) {
        try {
            Map<String, Object> attributeMap = this.jwtClaimsExtractorJackson2.extractClaims(request).entrySet().stream().filter(entry -> this.claimNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.jwtClaimsExtractorJackson2.toStringValue(entry.getValue())));
            return new HttpAttributes(attributeMap);
        }
        catch (Exception e) {
            log.trace("Encountered error while extracting attributes: `{}`", (Object)Optional.ofNullable(e.getCause()).orElse(e).getMessage());
            return HttpAttributes.EMPTY;
        }
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtAllMatchingClaimsExtractorJackson2)) {
            return false;
        }
        JwtAllMatchingClaimsExtractorJackson2 other = (JwtAllMatchingClaimsExtractorJackson2)o;
        List<String> this$claimNames = this.claimNames;
        List<String> other$claimNames = other.claimNames;
        if (this$claimNames == null ? other$claimNames != null : !((Object)this$claimNames).equals(other$claimNames)) {
            return false;
        }
        JwtClaimsExtractorJackson2 this$jwtClaimsExtractorJackson2 = this.jwtClaimsExtractorJackson2;
        JwtClaimsExtractorJackson2 other$jwtClaimsExtractorJackson2 = other.jwtClaimsExtractorJackson2;
        return !(this$jwtClaimsExtractorJackson2 == null ? other$jwtClaimsExtractorJackson2 != null : !((Object)this$jwtClaimsExtractorJackson2).equals(other$jwtClaimsExtractorJackson2));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $claimNames = this.claimNames;
        result = result * 59 + ($claimNames == null ? 43 : ((Object)$claimNames).hashCode());
        JwtClaimsExtractorJackson2 $jwtClaimsExtractorJackson2 = this.jwtClaimsExtractorJackson2;
        result = result * 59 + ($jwtClaimsExtractorJackson2 == null ? 43 : ((Object)$jwtClaimsExtractorJackson2).hashCode());
        return result;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static final class Builder {
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private List<String> claimNames;

        @Generated
        Builder() {
        }

        @Generated
        public Builder objectMapper(@Nullable ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public Builder claimNames(@Nullable List<String> claimNames) {
            this.claimNames = claimNames;
            return this;
        }

        @Generated
        public JwtAllMatchingClaimsExtractorJackson2 build() {
            return JwtAllMatchingClaimsExtractorJackson2.create(this.objectMapper, this.claimNames);
        }

        @Generated
        public String toString() {
            return "JwtAllMatchingClaimsExtractorJackson2.Builder(objectMapper=" + String.valueOf(this.objectMapper) + ", claimNames=" + String.valueOf(this.claimNames) + ")";
        }
    }
}

