/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.zalando.logbook.QueryFilter;
import org.zalando.logbook.core.DefaultFilters;

@API(status=API.Status.STABLE)
public final class QueryFilters {
    private QueryFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static QueryFilter defaultValue() {
        return DefaultFilters.defaultValues(QueryFilter.class).stream().reduce(QueryFilters.accessToken(), QueryFilter::merge);
    }

    @API(status=API.Status.MAINTAINED)
    public static QueryFilter accessToken() {
        return QueryFilters.replaceQuery("access_token", "XXX");
    }

    @API(status=API.Status.MAINTAINED)
    public static QueryFilter replaceQuery(String name, String replacement) {
        return QueryFilters.replaceQuery(name::equals, replacement);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static QueryFilter replaceQuery(String name, UnaryOperator<String> replacementFunction) {
        return QueryFilters.replaceQuery(name::equals, replacementFunction);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static QueryFilter replaceQuery(Predicate<String> predicate, String replacement) {
        return QueryFilters.replaceQuery(predicate, s -> replacement);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static QueryFilter replaceQuery(Predicate<String> predicate, UnaryOperator<String> replacementFunction) {
        return query -> QueryFilters.processParsedQueryParams(query, (paramName, paramValue) -> {
            if (paramValue == null) {
                return paramName;
            }
            String newValue = predicate.test((String)paramName) ? (String)replacementFunction.apply((String)paramValue) : paramValue;
            return paramName + "=" + newValue;
        });
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static QueryFilter removeQuery(String name) {
        Predicate<String> predicate = name::equals;
        return query -> QueryFilters.processParsedQueryParams(query, (paramName, paramValue) -> {
            if (predicate.test((String)paramName)) {
                return null;
            }
            return paramName + "=" + paramValue;
        });
    }

    private static String processParsedQueryParams(String query, BiFunction<String, String, String> nameValueHandler) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        while (tokenizer.hasMoreTokens()) {
            String newParam;
            String token = tokenizer.nextToken();
            int equalsIndex = token.indexOf(61);
            if (equalsIndex == -1) {
                newParam = nameValueHandler.apply(token, null);
            } else {
                String name = token.substring(0, equalsIndex);
                String value = token.substring(equalsIndex + 1);
                newParam = nameValueHandler.apply(name, value);
            }
            if (newParam == null) continue;
            result.add(newParam);
        }
        return String.join((CharSequence)"&", result);
    }
}

