/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.core.CookieHeaderFilter;
import org.zalando.logbook.core.DefaultFilters;

@API(status=API.Status.STABLE)
public final class HeaderFilters {
    private HeaderFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static HeaderFilter defaultValue() {
        return DefaultFilters.defaultValues(HeaderFilter.class).stream().reduce(HeaderFilters.authorization(), HeaderFilter::merge);
    }

    @API(status=API.Status.MAINTAINED)
    public static HeaderFilter authorization() {
        return HeaderFilters.replaceHeaders("Authorization", "XXX");
    }

    public static HeaderFilter replaceHeaders(String name, String replacement) {
        return HeaderFilters.replaceHeaders(Collections.singleton(name), replacement);
    }

    public static HeaderFilter replaceHeaders(Collection<String> names, String replacement) {
        return headers -> headers.apply(names, (name, previous) -> previous == null ? null : Collections.nCopies(previous.size(), replacement));
    }

    public static HeaderFilter replaceCookies(Predicate<String> predicate, String replacement) {
        return new CookieHeaderFilter(predicate, cookieValue -> replacement);
    }

    public static HeaderFilter replaceCookies(Predicate<String> predicate, Function<String, String> replacer) {
        return new CookieHeaderFilter(predicate, replacer);
    }

    public static HeaderFilter replaceHeaders(Predicate<String> keyPredicate, String replacement) {
        return HeaderFilters.replaceHeaders(HttpHeaders.predicate(keyPredicate), replacement);
    }

    public static HeaderFilter replaceHeaders(BiPredicate<String, String> predicate, String replacement) {
        return HeaderFilters.eachHeader((key, value) -> predicate.test((String)key, (String)value) ? replacement : value);
    }

    public static HeaderFilter eachHeader(BinaryOperator<String> operator) {
        return headers -> headers.apply((Collection)headers.keySet(), (name, values) -> {
            List<String> result = values.stream().map(value -> (String)operator.apply((String)name, value)).toList();
            if (result.equals(values)) {
                return values;
            }
            return result;
        });
    }

    public static HeaderFilter removeHeaders(String ... names) {
        return headers -> headers.delete(names);
    }

    public static HeaderFilter removeHeaders(Predicate<String> predicate) {
        return headers -> headers.delete(HttpHeaders.predicate((Predicate)predicate));
    }

    public static HeaderFilter removeHeaders(BiPredicate<String, String> predicate) {
        return headers -> headers.apply((name, previous) -> {
            if (previous.isEmpty()) {
                return previous;
            }
            List<String> next = previous.stream().filter(value -> predicate.negate().test((String)name, (String)value)).toList();
            if (next.isEmpty()) {
                return null;
            }
            if (next.size() == previous.size()) {
                return previous;
            }
            return next;
        });
    }
}

