/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HttpHeaders;

final class CookieHeaderFilter
implements HeaderFilter {
    private final Pattern pattern = Pattern.compile("(?<name>[^=; ]+)=(?<value>[^; ]*)");
    private final Map<String, Processor> processors = new HashMap<String, Processor>();
    private final Predicate<String> predicate;
    private final Function<String, String> replacer;

    public CookieHeaderFilter(Predicate<String> predicate, Function<String, String> replacer) {
        this.predicate = predicate;
        this.replacer = replacer;
        this.processors.put("Cookie", this::processCookie);
        this.processors.put("Set-Cookie", this::processSetCookie);
    }

    public HttpHeaders filter(HttpHeaders headers) {
        for (Map.Entry<String, Processor> entry : this.processors.entrySet()) {
            String name = entry.getKey();
            Processor processor = entry.getValue();
            if (!headers.containsKey((Object)name)) continue;
            return this.replace(headers, name, processor);
        }
        return headers;
    }

    private HttpHeaders replace(HttpHeaders headers, String name, Processor processor) {
        return headers.apply(name, values -> values.stream().map(value -> this.replace(processor, (String)value)).toList());
    }

    private String replace(Processor processor, String value) {
        Matcher matcher = this.pattern.matcher(value);
        StringBuffer result = new StringBuffer(value.length());
        processor.process(matcher, result);
        matcher.appendTail(result);
        return result.toString();
    }

    public void processCookie(Matcher matcher, StringBuffer result) {
        while (matcher.find()) {
            this.process(matcher, result);
        }
    }

    public void processSetCookie(Matcher matcher, StringBuffer result) {
        if (matcher.find()) {
            this.process(matcher, result);
        }
    }

    private void process(Matcher matcher, StringBuffer result) {
        String matchedName = matcher.group("name");
        if (this.predicate.test(matchedName)) {
            String matchedValue = matcher.group("value");
            matcher.appendReplacement(result, "${name}");
            result.append('=');
            result.append(this.replacer.apply(matchedValue));
        } else {
            matcher.appendReplacement(result, "$0");
        }
    }

    @FunctionalInterface
    private static interface Processor {
        public void process(Matcher var1, StringBuffer var2);
    }
}

