/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.RequestURI;
import org.zalando.logbook.common.Glob;
import org.zalando.logbook.common.MediaTypeQuery;

@API(status=API.Status.STABLE)
public final class Conditions {
    private Conditions() {
    }

    @SafeVarargs
    public static <T extends HttpMessage> Predicate<T> exclude(Predicate<T> ... predicates) {
        return Conditions.exclude(List.of(predicates));
    }

    public static <T extends HttpMessage> Predicate<T> exclude(Collection<Predicate<T>> predicates) {
        return Conditions.exclude(predicates.stream());
    }

    public static <T extends HttpMessage> Predicate<T> exclude(Stream<Predicate<T>> predicates) {
        return predicates.map(Predicate::negate).reduce(Predicate::and).orElse($ -> true);
    }

    public static <T extends HttpRequest> Predicate<T> requestTo(String pattern) {
        Predicate predicate = Glob.compile((String)pattern);
        return pattern.startsWith("/") ? Conditions.requestTo(HttpRequest::getPath, predicate) : Conditions.requestTo(request -> RequestURI.reconstruct((HttpRequest)request, (RequestURI.Component[])new RequestURI.Component[]{RequestURI.Component.SCHEME, RequestURI.Component.AUTHORITY, RequestURI.Component.PATH}), predicate);
    }

    private static <T extends HttpRequest> Predicate<T> requestTo(Function<HttpRequest, String> extractor, Predicate<String> predicate) {
        return request -> predicate.test((String)extractor.apply((HttpRequest)request));
    }

    public static <T extends HttpRequest> Predicate<T> requestWithMethod(String httpMethod) {
        return request -> request.getMethod().equalsIgnoreCase(httpMethod);
    }

    public static <T extends HttpMessage> Predicate<T> contentType(String contentType, String ... contentTypes) {
        Predicate query = MediaTypeQuery.compile((String)contentType, (String[])contentTypes);
        return message -> query.test(message.getContentType());
    }

    public static <T extends HttpMessage> Predicate<T> withoutContentType() {
        return message -> message.getContentType() == null;
    }

    public static <T extends HttpMessage> Predicate<T> header(String key, String value) {
        return message -> ((List)message.getHeaders().getOrDefault((Object)key, Collections.emptyList())).contains(value);
    }

    public static <T extends HttpMessage> Predicate<T> header(String key, Predicate<String> predicate) {
        return message -> ((List)message.getHeaders().getOrDefault((Object)key, Collections.emptyList())).stream().anyMatch(predicate);
    }

    public static <T extends HttpMessage> Predicate<T> header(BiPredicate<String, String> predicate) {
        return message -> message.getHeaders().entrySet().stream().anyMatch(e -> ((List)e.getValue()).stream().anyMatch(v -> predicate.test((String)e.getKey(), (String)v)));
    }

    public static <T extends HttpMessage> Predicate<T> withoutHeader(String key) {
        return message -> !message.getHeaders().containsKey((Object)key);
    }
}

