/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpLogWriter;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.Sink;

@API(status=API.Status.EXPERIMENTAL)
public final class CommonsLogFormatSink
implements Sink {
    private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendLiteral('[').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('/').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT).appendLiteral('/').appendValue(ChronoField.YEAR, 4).appendLiteral(':').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(' ').appendOffset("+HHMM", "0000").appendLiteral(']').toFormatter();
    private final HttpLogWriter writer;
    private final ZoneId timeZone;

    public CommonsLogFormatSink(HttpLogWriter writer) {
        this(writer, ZoneId.systemDefault());
    }

    public boolean isActive() {
        return this.writer.isActive();
    }

    public void write(Precorrelation precorrelation, HttpRequest request) {
    }

    public void write(Correlation correlation, HttpRequest request, HttpResponse response) throws IOException {
        StringBuilder output = new StringBuilder(120);
        output.append(request.getRemote());
        output.append(' ');
        output.append('-');
        output.append(' ');
        output.append('-');
        output.append(' ');
        this.formatter.formatTo(correlation.getStart().atZone(this.timeZone), output);
        output.append(' ');
        output.append('\"');
        output.append(request.getMethod());
        output.append(' ');
        output.append(request.getPath());
        String query = request.getQuery();
        if (!query.isEmpty()) {
            output.append('?');
            output.append(query);
        }
        output.append(' ');
        output.append(request.getProtocolVersion());
        output.append('\"');
        output.append(' ');
        output.append(response.getStatus());
        output.append(' ');
        int bytes = response.getBody().length;
        if (bytes == 0) {
            output.append('-');
        } else {
            output.append(bytes);
        }
        this.writer.write(correlation, output.toString());
    }

    @Generated
    public CommonsLogFormatSink(HttpLogWriter writer, ZoneId timeZone) {
        this.writer = writer;
        this.timeZone = timeZone;
    }
}

