/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.CorrelationId;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.LogbookFactory;
import org.zalando.logbook.PathFilter;
import org.zalando.logbook.QueryFilter;
import org.zalando.logbook.RequestFilter;
import org.zalando.logbook.ResponseFilter;
import org.zalando.logbook.Sink;
import org.zalando.logbook.Strategy;
import org.zalando.logbook.attributes.AttributeExtractor;

@API(status=API.Status.INTERNAL)
public final class LogbookCreator {
    private LogbookCreator() {
    }

    private static Logbook create(@Nullable Predicate<HttpRequest> condition, @Nullable CorrelationId correlationId, List<QueryFilter> queryFilters, List<PathFilter> pathFilters, List<HeaderFilter> headerFilters, List<BodyFilter> bodyFilters, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, @Nullable Strategy strategy, @Nullable AttributeExtractor attributeExtractor, @Nullable Sink sink) {
        QueryFilter queryFilter = queryFilters.stream().reduce(QueryFilter::merge).orElse(null);
        PathFilter pathFilter = pathFilters.stream().reduce(PathFilter::merge).orElse(null);
        HeaderFilter headerFilter = headerFilters.stream().reduce(HeaderFilter::merge).orElse(null);
        BodyFilter bodyFilter = bodyFilters.stream().reduce(BodyFilter::merge).orElse(null);
        RequestFilter requestFilter = requestFilters.stream().reduce(RequestFilter::merge).orElse(null);
        ResponseFilter responseFilter = responseFilters.stream().reduce(ResponseFilter::merge).orElse(null);
        LogbookFactory factory = LogbookFactory.INSTANCE;
        return factory.create(condition, correlationId, queryFilter, pathFilter, headerFilter, bodyFilter, requestFilter, responseFilter, strategy, attributeExtractor, sink);
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @API(status=API.Status.STABLE)
    public static final class Builder {
        @Generated
        private Predicate<HttpRequest> condition;
        @Generated
        private CorrelationId correlationId;
        @Generated
        private ArrayList<QueryFilter> queryFilters;
        @Generated
        private ArrayList<PathFilter> pathFilters;
        @Generated
        private ArrayList<HeaderFilter> headerFilters;
        @Generated
        private ArrayList<BodyFilter> bodyFilters;
        @Generated
        private ArrayList<RequestFilter> requestFilters;
        @Generated
        private ArrayList<ResponseFilter> responseFilters;
        @Generated
        private Strategy strategy;
        @Generated
        private AttributeExtractor attributeExtractor;
        @Generated
        private Sink sink;

        @Generated
        Builder() {
        }

        @Generated
        public Builder condition(@Nullable Predicate<HttpRequest> condition) {
            this.condition = condition;
            return this;
        }

        @Generated
        public Builder correlationId(@Nullable CorrelationId correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        @Generated
        public Builder queryFilter(QueryFilter queryFilter) {
            if (this.queryFilters == null) {
                this.queryFilters = new ArrayList();
            }
            this.queryFilters.add(queryFilter);
            return this;
        }

        @Generated
        public Builder queryFilters(Collection<? extends QueryFilter> queryFilters) {
            if (queryFilters == null) {
                throw new NullPointerException("queryFilters cannot be null");
            }
            if (this.queryFilters == null) {
                this.queryFilters = new ArrayList();
            }
            this.queryFilters.addAll(queryFilters);
            return this;
        }

        @Generated
        public Builder clearQueryFilters() {
            if (this.queryFilters != null) {
                this.queryFilters.clear();
            }
            return this;
        }

        @Generated
        public Builder pathFilter(PathFilter pathFilter) {
            if (this.pathFilters == null) {
                this.pathFilters = new ArrayList();
            }
            this.pathFilters.add(pathFilter);
            return this;
        }

        @Generated
        public Builder pathFilters(Collection<? extends PathFilter> pathFilters) {
            if (pathFilters == null) {
                throw new NullPointerException("pathFilters cannot be null");
            }
            if (this.pathFilters == null) {
                this.pathFilters = new ArrayList();
            }
            this.pathFilters.addAll(pathFilters);
            return this;
        }

        @Generated
        public Builder clearPathFilters() {
            if (this.pathFilters != null) {
                this.pathFilters.clear();
            }
            return this;
        }

        @Generated
        public Builder headerFilter(HeaderFilter headerFilter) {
            if (this.headerFilters == null) {
                this.headerFilters = new ArrayList();
            }
            this.headerFilters.add(headerFilter);
            return this;
        }

        @Generated
        public Builder headerFilters(Collection<? extends HeaderFilter> headerFilters) {
            if (headerFilters == null) {
                throw new NullPointerException("headerFilters cannot be null");
            }
            if (this.headerFilters == null) {
                this.headerFilters = new ArrayList();
            }
            this.headerFilters.addAll(headerFilters);
            return this;
        }

        @Generated
        public Builder clearHeaderFilters() {
            if (this.headerFilters != null) {
                this.headerFilters.clear();
            }
            return this;
        }

        @Generated
        public Builder bodyFilter(BodyFilter bodyFilter) {
            if (this.bodyFilters == null) {
                this.bodyFilters = new ArrayList();
            }
            this.bodyFilters.add(bodyFilter);
            return this;
        }

        @Generated
        public Builder bodyFilters(Collection<? extends BodyFilter> bodyFilters) {
            if (bodyFilters == null) {
                throw new NullPointerException("bodyFilters cannot be null");
            }
            if (this.bodyFilters == null) {
                this.bodyFilters = new ArrayList();
            }
            this.bodyFilters.addAll(bodyFilters);
            return this;
        }

        @Generated
        public Builder clearBodyFilters() {
            if (this.bodyFilters != null) {
                this.bodyFilters.clear();
            }
            return this;
        }

        @Generated
        public Builder requestFilter(RequestFilter requestFilter) {
            if (this.requestFilters == null) {
                this.requestFilters = new ArrayList();
            }
            this.requestFilters.add(requestFilter);
            return this;
        }

        @Generated
        public Builder requestFilters(Collection<? extends RequestFilter> requestFilters) {
            if (requestFilters == null) {
                throw new NullPointerException("requestFilters cannot be null");
            }
            if (this.requestFilters == null) {
                this.requestFilters = new ArrayList();
            }
            this.requestFilters.addAll(requestFilters);
            return this;
        }

        @Generated
        public Builder clearRequestFilters() {
            if (this.requestFilters != null) {
                this.requestFilters.clear();
            }
            return this;
        }

        @Generated
        public Builder responseFilter(ResponseFilter responseFilter) {
            if (this.responseFilters == null) {
                this.responseFilters = new ArrayList();
            }
            this.responseFilters.add(responseFilter);
            return this;
        }

        @Generated
        public Builder responseFilters(Collection<? extends ResponseFilter> responseFilters) {
            if (responseFilters == null) {
                throw new NullPointerException("responseFilters cannot be null");
            }
            if (this.responseFilters == null) {
                this.responseFilters = new ArrayList();
            }
            this.responseFilters.addAll(responseFilters);
            return this;
        }

        @Generated
        public Builder clearResponseFilters() {
            if (this.responseFilters != null) {
                this.responseFilters.clear();
            }
            return this;
        }

        @Generated
        public Builder strategy(@Nullable Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        @Generated
        public Builder attributeExtractor(@Nullable AttributeExtractor attributeExtractor) {
            this.attributeExtractor = attributeExtractor;
            return this;
        }

        @Generated
        public Builder sink(@Nullable Sink sink) {
            this.sink = sink;
            return this;
        }

        @Generated
        public Logbook build() {
            return LogbookCreator.create(this.condition, this.correlationId, switch (this.queryFilters == null ? 0 : this.queryFilters.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.queryFilters.get(0));
                default -> Collections.unmodifiableList(new ArrayList<QueryFilter>(this.queryFilters));
            }, switch (this.pathFilters == null ? 0 : this.pathFilters.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.pathFilters.get(0));
                default -> Collections.unmodifiableList(new ArrayList<PathFilter>(this.pathFilters));
            }, switch (this.headerFilters == null ? 0 : this.headerFilters.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.headerFilters.get(0));
                default -> Collections.unmodifiableList(new ArrayList<HeaderFilter>(this.headerFilters));
            }, switch (this.bodyFilters == null ? 0 : this.bodyFilters.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.bodyFilters.get(0));
                default -> Collections.unmodifiableList(new ArrayList<BodyFilter>(this.bodyFilters));
            }, switch (this.requestFilters == null ? 0 : this.requestFilters.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.requestFilters.get(0));
                default -> Collections.unmodifiableList(new ArrayList<RequestFilter>(this.requestFilters));
            }, switch (this.responseFilters == null ? 0 : this.responseFilters.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.responseFilters.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ResponseFilter>(this.responseFilters));
            }, this.strategy, this.attributeExtractor, this.sink);
        }

        @Generated
        public String toString() {
            return "LogbookCreator.Builder(condition=" + String.valueOf(this.condition) + ", correlationId=" + String.valueOf(this.correlationId) + ", queryFilters=" + String.valueOf(this.queryFilters) + ", pathFilters=" + String.valueOf(this.pathFilters) + ", headerFilters=" + String.valueOf(this.headerFilters) + ", bodyFilters=" + String.valueOf(this.bodyFilters) + ", requestFilters=" + String.valueOf(this.requestFilters) + ", responseFilters=" + String.valueOf(this.responseFilters) + ", strategy=" + String.valueOf(this.strategy) + ", attributeExtractor=" + String.valueOf(this.attributeExtractor) + ", sink=" + String.valueOf(this.sink) + ")";
        }
    }
}

