/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apiguardian.api.API;
import org.zalando.logbook.ContentType;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.Origin;

@API(status=API.Status.STABLE)
public interface HttpMessage {
    default public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin();

    public HttpHeaders getHeaders();

    @Nullable
    default public String getContentType() {
        return Optional.ofNullable(this.getHeaders()).map(headers -> headers.getFirst("Content-Type")).map(ContentType::parseMimeType).orElse(null);
    }

    default public Charset getCharset() {
        return Optional.ofNullable(this.getHeaders()).map(headers -> headers.getFirst("Content-Type")).map(ContentType::parseCharset).orElse(StandardCharsets.UTF_8);
    }

    public byte[] getBody() throws IOException;

    default public String getBodyAsString() throws IOException {
        return new String(this.getBody(), this.getCharset());
    }
}

