/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import lombok.Generated;

public final class ContentType {
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String SEMICOLON = ";";
    private static final String CHARSET_PREFIX = "charset=";

    @Nullable
    static String parseMimeType(@Nullable String contentTypeValue) {
        if (contentTypeValue != null) {
            int indexOfSemicolon = contentTypeValue.indexOf(SEMICOLON);
            if (indexOfSemicolon != -1) {
                return contentTypeValue.substring(0, indexOfSemicolon);
            }
            return contentTypeValue.length() > 0 ? contentTypeValue : null;
        }
        return null;
    }

    @Nullable
    public static Charset parseCharset(@Nullable String contentTypeValue) {
        if (contentTypeValue != null) {
            int indexOfEncoding;
            String charsetRaw = null;
            int indexOfCharset = contentTypeValue.toLowerCase().indexOf(CHARSET_PREFIX);
            if (indexOfCharset != -1 && (indexOfEncoding = indexOfCharset + CHARSET_PREFIX.length()) < contentTypeValue.length()) {
                String charsetCandidate = contentTypeValue.substring(indexOfEncoding);
                int indexOfSemicolon = charsetCandidate.indexOf(SEMICOLON);
                String string = charsetRaw = indexOfSemicolon == -1 ? charsetCandidate : charsetCandidate.substring(0, indexOfSemicolon);
            }
            if (charsetRaw != null) {
                if (charsetRaw.length() > 2 && charsetRaw.charAt(0) == '\"' && charsetRaw.charAt(charsetRaw.length() - 1) == '\"') {
                    charsetRaw = charsetRaw.substring(1, charsetRaw.length() - 1);
                }
                try {
                    return Charset.forName(charsetRaw);
                }
                catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (ContentType.isJsonMediaType(contentTypeValue)) {
            return StandardCharsets.UTF_8;
        }
        return null;
    }

    public static boolean isJsonMediaType(@Nullable String contentType) {
        if (contentType == null) {
            return false;
        }
        String lowerCasedContentType = contentType.toLowerCase();
        if (lowerCasedContentType.startsWith("application/")) {
            String mediaType = ContentType.parseMimeType(lowerCasedContentType);
            return mediaType.endsWith("/json") || mediaType.endsWith("+json");
        }
        return false;
    }

    @Generated
    private ContentType() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

