/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import org.zalando.logbook.Fold;
import org.zalando.logbook.HttpHeaders;

interface ApplyHttpHeaders
extends HttpHeaders {
    @Override
    default public HttpHeaders apply(String name, UnaryOperator<List<String>> operator) {
        return this.apply(Collections.singleton(name), (String ignored, List<String> previous) -> (Collection)operator.apply((List<String>)previous));
    }

    @Override
    default public HttpHeaders apply(Collection<String> names, BiFunction<String, List<String>, Collection<String>> operator) {
        ApplyHttpHeaders self = this;
        return Fold.fold(names, self, (result, name) -> {
            List previous = (List)this.get(name);
            return this.applyTo(operator, (String)name, previous, (HttpHeaders)result);
        });
    }

    @Override
    default public HttpHeaders apply(BiPredicate<String, List<String>> predicate, BiFunction<String, List<String>, Collection<String>> operator) {
        return this.apply((name, previous) -> {
            if (predicate.test((String)name, (List<String>)previous)) {
                return (Collection)operator.apply((String)name, (List<String>)previous);
            }
            return previous;
        });
    }

    @Override
    default public HttpHeaders apply(BiFunction<String, List<String>, Collection<String>> operator) {
        ApplyHttpHeaders self = this;
        return Fold.fold(this.entrySet(), self, (result, entry) -> {
            String name = (String)entry.getKey();
            List previous = (List)entry.getValue();
            return this.applyTo(operator, name, previous, (HttpHeaders)result);
        });
    }

    private HttpHeaders applyTo(BiFunction<String, List<String>, Collection<String>> operator, String name, List<String> previous, HttpHeaders headers) {
        Collection<String> next = operator.apply(name, previous);
        return next == null ? headers.delete(name) : headers.update(name, next);
    }
}

