/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.lock;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import ext.deployit.community.plugin.lock.LockHelper;
import java.util.List;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, virtual=false, description="Manager for container locks")
public class Manager
extends BaseContainer {
    @ControlTask(description="Clears all locks")
    public List<Step> clearLocks() {
        Step clearLocksStep = new Step(){

            public String getDescription() {
                return "Clearing all locks";
            }

            public StepExitCode execute(ExecutionContext arg0) throws Exception {
                new LockHelper().clearLocks();
                return StepExitCode.SUCCESS;
            }

            public int getOrder() {
                return 0;
            }
        };
        return Lists.newArrayList((Object[])new Step[]{clearLocksStep});
    }

    @ControlTask(description="Lists all locks")
    public List<Step> listLocks() {
        Step listLocksStep = new Step(){

            public String getDescription() {
                return "Listing all locks";
            }

            public StepExitCode execute(ExecutionContext ctx) throws Exception {
                ctx.logOutput("The following CIs are currently locked:");
                List<String> locksListing = new LockHelper().listLocks();
                if (locksListing.isEmpty()) {
                    ctx.logOutput("<none>");
                } else {
                    for (String string : locksListing) {
                        ctx.logOutput("- " + string);
                    }
                }
                return StepExitCode.SUCCESS;
            }

            public int getOrder() {
                return 0;
            }
        };
        return Lists.newArrayList((Object[])new Step[]{listLocksStep});
    }
}

