/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.lock;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import ext.deployit.community.plugin.lock.LockCleanupListener;
import ext.deployit.community.plugin.lock.LockHelper;
import java.util.Set;

public class AcquireAllLocksStep
implements Step {
    private static final int ACQUIRE_LOCKS_ORDER = 2;
    private final Set<ConfigurationItem> cisToBeLocked;
    private final LockHelper lockHelper;

    public AcquireAllLocksStep(LockHelper lockHelper, Set<ConfigurationItem> cisToBeLocked) {
        this.lockHelper = lockHelper;
        this.cisToBeLocked = cisToBeLocked;
    }

    public StepExitCode execute(ExecutionContext context) throws Exception {
        context.logOutput("Attempting to acquire locks on CIs " + this.cisToBeLocked);
        if (this.lockHelper.atomicallyLock(this.cisToBeLocked)) {
            context.logOutput("All locks acquired");
            context.setAttribute("lockCleanupListener", (Object)new LockCleanupListener(this.lockHelper, this.cisToBeLocked));
            return StepExitCode.SUCCESS;
        }
        context.logError("Failed to acquire one or more locks");
        return StepExitCode.PAUSE;
    }

    public String getDescription() {
        return "Acquiring locks for the following CIs: " + this.cisToBeLocked.toString();
    }

    public int getOrder() {
        return 2;
    }
}

