/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.impl.nio;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import wiremock.org.apache.hc.client5.http.DnsResolver;
import wiremock.org.apache.hc.client5.http.SchemePortResolver;
import wiremock.org.apache.hc.client5.http.UnsupportedSchemeException;
import wiremock.org.apache.hc.client5.http.config.TlsConfig;
import wiremock.org.apache.hc.client5.http.impl.ConnPoolSupport;
import wiremock.org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import wiremock.org.apache.hc.client5.http.impl.nio.DefaultManagedAsyncClientConnection;
import wiremock.org.apache.hc.client5.http.impl.nio.MultihomeIOSessionRequester;
import wiremock.org.apache.hc.client5.http.nio.AsyncClientConnectionOperator;
import wiremock.org.apache.hc.client5.http.nio.ManagedAsyncClientConnection;
import wiremock.org.apache.hc.client5.http.routing.RoutingSupport;
import wiremock.org.apache.hc.core5.annotation.Internal;
import wiremock.org.apache.hc.core5.concurrent.BasicFuture;
import wiremock.org.apache.hc.core5.concurrent.CallbackContribution;
import wiremock.org.apache.hc.core5.concurrent.ComplexFuture;
import wiremock.org.apache.hc.core5.concurrent.FutureCallback;
import wiremock.org.apache.hc.core5.concurrent.FutureContribution;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.URIScheme;
import wiremock.org.apache.hc.core5.http.config.Lookup;
import wiremock.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.net.NamedEndpoint;
import wiremock.org.apache.hc.core5.reactor.ConnectionInitiator;
import wiremock.org.apache.hc.core5.reactor.IOSession;
import wiremock.org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import wiremock.org.apache.hc.core5.util.Args;
import wiremock.org.apache.hc.core5.util.Timeout;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

@Internal
public class DefaultAsyncClientConnectionOperator
implements AsyncClientConnectionOperator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAsyncClientConnectionOperator.class);
    private final SchemePortResolver schemePortResolver;
    private final MultihomeIOSessionRequester sessionRequester;
    private final Lookup<TlsStrategy> tlsStrategyLookup;

    protected DefaultAsyncClientConnectionOperator(Lookup<TlsStrategy> tlsStrategyLookup, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this.tlsStrategyLookup = Args.notNull(tlsStrategyLookup, "TLS strategy lookup");
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.sessionRequester = new MultihomeIOSessionRequester(dnsResolver);
    }

    @Override
    public Future<ManagedAsyncClientConnection> connect(ConnectionInitiator connectionInitiator, HttpHost host, SocketAddress localAddress, Timeout connectTimeout, Object attachment, FutureCallback<ManagedAsyncClientConnection> callback) {
        return this.connect(connectionInitiator, host, null, localAddress, connectTimeout, attachment, null, callback);
    }

    @Override
    public Future<ManagedAsyncClientConnection> connect(ConnectionInitiator connectionInitiator, final HttpHost endpointHost, final NamedEndpoint endpointName, SocketAddress localAddress, final Timeout connectTimeout, final Object attachment, final HttpContext context, FutureCallback<ManagedAsyncClientConnection> callback) {
        Args.notNull(connectionInitiator, "Connection initiator");
        Args.notNull(endpointHost, "Host");
        final ComplexFuture<ManagedAsyncClientConnection> future = new ComplexFuture<ManagedAsyncClientConnection>(callback);
        HttpHost remoteEndpoint = RoutingSupport.normalize(endpointHost, this.schemePortResolver);
        InetAddress remoteAddress = endpointHost.getAddress();
        final TlsConfig tlsConfig = attachment instanceof TlsConfig ? (TlsConfig)attachment : TlsConfig.DEFAULT;
        this.onBeforeSocketConnect(context, endpointHost);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} connecting {}->{} ({})", endpointHost, localAddress, remoteAddress, connectTimeout);
        }
        Future<IOSession> sessionFuture = this.sessionRequester.connect(connectionInitiator, remoteEndpoint, remoteAddress != null ? new InetSocketAddress(remoteAddress, remoteEndpoint.getPort()) : null, localAddress, connectTimeout, (Object)tlsConfig.getHttpVersionPolicy(), new FutureCallback<IOSession>(){

            @Override
            public void completed(IOSession session) {
                TlsStrategy tlsStrategy;
                final DefaultManagedAsyncClientConnection connection = new DefaultManagedAsyncClientConnection(session);
                DefaultAsyncClientConnectionOperator.this.onAfterSocketConnect(context, endpointHost);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} {} connected {}->{}", ConnPoolSupport.getId(connection), endpointHost, connection.getLocalAddress(), connection.getRemoteAddress());
                }
                TlsStrategy tlsStrategy2 = tlsStrategy = DefaultAsyncClientConnectionOperator.this.tlsStrategyLookup != null ? (TlsStrategy)DefaultAsyncClientConnectionOperator.this.tlsStrategyLookup.lookup(endpointHost.getSchemeName()) : null;
                if (tlsStrategy != null) {
                    try {
                        final Timeout socketTimeout = connection.getSocketTimeout();
                        Timeout handshakeTimeout = tlsConfig.getHandshakeTimeout() != null ? tlsConfig.getHandshakeTimeout() : connectTimeout;
                        final NamedEndpoint tlsName = endpointName != null ? endpointName : endpointHost;
                        DefaultAsyncClientConnectionOperator.this.onBeforeTlsHandshake(context, endpointHost);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} {} upgrading to TLS", (Object)ConnPoolSupport.getId(connection), (Object)tlsName);
                        }
                        tlsStrategy.upgrade(connection, tlsName, attachment, handshakeTimeout, (FutureCallback<TransportSecurityLayer>)new FutureContribution<TransportSecurityLayer>((BasicFuture)future){

                            @Override
                            public void completed(TransportSecurityLayer transportSecurityLayer) {
                                connection.setSocketTimeout(socketTimeout);
                                future.completed(connection);
                                DefaultAsyncClientConnectionOperator.this.onAfterTlsHandshake(context, endpointHost);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("{} {} upgraded to TLS", (Object)ConnPoolSupport.getId(connection), (Object)tlsName);
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        future.failed(ex);
                    }
                } else {
                    future.completed(connection);
                }
            }

            @Override
            public void failed(Exception ex) {
                future.failed(ex);
            }

            @Override
            public void cancelled() {
                future.cancel();
            }
        });
        future.setDependency(sessionFuture);
        return future;
    }

    @Override
    public void upgrade(ManagedAsyncClientConnection connection, HttpHost host, Object attachment) {
        this.upgrade(connection, host, null, attachment, null, null);
    }

    @Override
    public void upgrade(final ManagedAsyncClientConnection connection, HttpHost endpointHost, NamedEndpoint endpointName, Object attachment, HttpContext context, final FutureCallback<ManagedAsyncClientConnection> callback) {
        TlsStrategy tlsStrategy;
        String newProtocol = URIScheme.HTTP.same(endpointHost.getSchemeName()) ? URIScheme.HTTPS.id : endpointHost.getSchemeName();
        TlsStrategy tlsStrategy2 = tlsStrategy = this.tlsStrategyLookup != null ? this.tlsStrategyLookup.lookup(newProtocol) : null;
        if (tlsStrategy != null) {
            NamedEndpoint tlsName;
            NamedEndpoint namedEndpoint = tlsName = endpointName != null ? endpointName : endpointHost;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {} upgrading to TLS", (Object)ConnPoolSupport.getId(connection), (Object)tlsName);
            }
            tlsStrategy.upgrade(connection, tlsName, attachment, null, (FutureCallback<TransportSecurityLayer>)new CallbackContribution<TransportSecurityLayer>(callback){

                @Override
                public void completed(TransportSecurityLayer transportSecurityLayer) {
                    if (callback != null) {
                        callback.completed(connection);
                    }
                }
            });
        } else {
            callback.failed(new UnsupportedSchemeException(newProtocol + " protocol is not supported"));
        }
    }

    protected void onBeforeSocketConnect(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onAfterSocketConnect(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onBeforeTlsHandshake(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onAfterTlsHandshake(HttpContext httpContext, HttpHost endpointHost) {
    }
}

