/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Locale;
import wiremock.org.apache.hc.client5.http.SchemePortResolver;
import wiremock.org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import wiremock.org.apache.hc.client5.http.protocol.RedirectStrategy;
import wiremock.org.apache.hc.client5.http.utils.URIUtils;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.Internal;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.Header;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.HttpResponse;
import wiremock.org.apache.hc.core5.http.ProtocolException;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.net.URIBuilder;
import wiremock.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultRedirectStrategy
implements RedirectStrategy {
    private final SchemePortResolver schemePortResolver;
    public static final DefaultRedirectStrategy INSTANCE = new DefaultRedirectStrategy();

    @Internal
    public DefaultRedirectStrategy(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public DefaultRedirectStrategy() {
        this(null);
    }

    @Override
    public boolean isRedirectAllowed(HttpHost currentTarget, HttpHost newTarget, HttpRequest redirect, HttpContext context) {
        if (!this.isSameAuthority(currentTarget, newTarget)) {
            Iterator<Header> it = redirect.headerIterator();
            while (it.hasNext()) {
                Header header = it.next();
                if (!header.isSensitive() && !header.getName().equalsIgnoreCase("Authorization") && !header.getName().equalsIgnoreCase("Cookie")) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSameAuthority(HttpHost h1, HttpHost h2) {
        int port2;
        String host2;
        if (h1 == null || h2 == null) {
            return false;
        }
        String host1 = h1.getHostName();
        if (!host1.equalsIgnoreCase(host2 = h2.getHostName())) {
            return false;
        }
        int port1 = this.schemePortResolver.resolve(h1);
        return port1 == (port2 = this.schemePortResolver.resolve(h2));
    }

    @Override
    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        Args.notNull(request, "HTTP request");
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Location")) {
            return false;
        }
        int statusCode = response.getCode();
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    @Override
    public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(response, "HTTP response");
        Args.notNull(context, "HTTP context");
        Header locationHeader = response.getFirstHeader("Location");
        if (locationHeader == null) {
            throw new HttpException("Redirect location is missing");
        }
        String location = locationHeader.getValue();
        URI uri = this.createLocationURI(location);
        try {
            if (!uri.isAbsolute()) {
                uri = URIUtils.resolve(request.getUri(), uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), ex);
        }
        return uri;
    }

    protected URI createLocationURI(String location) throws ProtocolException {
        try {
            URIBuilder b = new URIBuilder(new URI(location).normalize());
            String host = b.getHost();
            if (host != null) {
                b.setHost(host.toLowerCase(Locale.ROOT));
            }
            if (b.isPathEmpty()) {
                b.setPathSegments("");
            }
            return b.build();
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid redirect URI: " + location, ex);
        }
    }
}

