/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.i18n;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class Locales {
    public static final String[] SUPPORTED_LANGUAGE_TAGS = new String[]{"ar", "cs", "da", "de", "es", "fa", "fi", "fr", "iw", "he", "hr", "hu", "it", "ja", "ko", "nb", "nl", "pl", "pt", "ro", "ru", "sk", "sv", "th", "tr", "uk", "vi", "zh-CN", "zh-TW"};
    public static final List<Locale> SUPPORTED_LOCALES = Locales.of(SUPPORTED_LANGUAGE_TAGS);

    public static List<Locale> getSupportedLocales() {
        return SUPPORTED_LOCALES;
    }

    public static List<Locale> of(String ... languageTags) {
        return Arrays.asList(languageTags).stream().map(Locale::forLanguageTag).collect(Collectors.toList());
    }

    public static Locale findSupported(String priorityList) {
        return Locales.findSupported(priorityList, Locales.getSupportedLocales());
    }

    public static Locale findSupported(String priorityList, Collection<Locale> locales) {
        return Locales.findSupported(Locale.LanguageRange.parse(priorityList), locales, Locale.FilteringMode.AUTOSELECT_FILTERING);
    }

    public static Locale findSupported(List<Locale.LanguageRange> priorityList, Collection<Locale> locales, Locale.FilteringMode filteringMode) {
        Locale result = Locale.lookup(priorityList, locales);
        if (result != null) {
            return result;
        }
        List<Locale> matching = Locale.filter(priorityList, locales, filteringMode);
        if (!matching.isEmpty()) {
            return matching.get(0);
        }
        return Locale.ROOT;
    }
}

