/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.ssl;

import com.github.tomakehurst.wiremock.common.ArrayFunctions;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ListFunctions;
import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.http.ssl.CompositeTrustManager;
import com.github.tomakehurst.wiremock.http.ssl.TrustStrategy;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

public class SSLContextBuilder {
    private final Set<KeyManager> keyManagers = new LinkedHashSet<KeyManager>();
    private final Set<TrustManager> trustManagers = new LinkedHashSet<TrustManager>();

    public static SSLContextBuilder create() {
        return new SSLContextBuilder();
    }

    public SSLContextBuilder loadTrustMaterial(KeyStore truststore) throws KeyStoreException, NoSuchAlgorithmException {
        return this.loadTrustMaterial(truststore, null);
    }

    public SSLContextBuilder loadTrustMaterial(KeyStore truststore, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException {
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManager[] tms = this.loadTrustManagers(truststore, algorithm);
        TrustManager[] allTms = ArrayFunctions.concat(tms, this.loadDefaultTrustManagers());
        Pair<List<TrustManager>, List<X509ExtendedTrustManager>> split = ListFunctions.splitByType(allTms, X509ExtendedTrustManager.class);
        List otherTms = (List)split.a;
        List x509Tms = (List)split.b;
        if (!x509Tms.isEmpty()) {
            CompositeTrustManager trustManager = new CompositeTrustManager(x509Tms);
            CompositeTrustManager tm = trustStrategy == null ? trustManager : this.addStrategy(trustManager, trustStrategy);
            this.trustManagers.add(tm);
        }
        this.trustManagers.addAll(otherTms);
        return this;
    }

    public SSLContextBuilder loadTrustMaterial(TrustStrategy trustStrategy) {
        TrustManager[] tms = this.loadDefaultTrustManagers();
        TrustManager[] tmsWithStrategy = this.addStrategy(tms, trustStrategy);
        Collections.addAll(this.trustManagers, tmsWithStrategy);
        return this;
    }

    private TrustManager[] loadTrustManagers(KeyStore truststore, String algorithm) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(algorithm);
        tmfactory.init(truststore);
        TrustManager[] tms = tmfactory.getTrustManagers();
        return tms == null ? new TrustManager[]{} : tms;
    }

    private TrustManager[] loadDefaultTrustManagers() {
        try {
            return this.loadTrustManagers(null, TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            return (TrustManager[])Exceptions.throwUnchecked(e, null);
        }
    }

    private TrustManager[] addStrategy(TrustManager[] allTms, TrustStrategy trustStrategy) {
        TrustManager[] withStrategy = new TrustManager[allTms.length];
        for (int i = 0; i < allTms.length; ++i) {
            withStrategy[i] = this.addStrategy(allTms[i], trustStrategy);
        }
        return withStrategy;
    }

    private TrustManager addStrategy(TrustManager tm, TrustStrategy trustStrategy) {
        if (tm instanceof X509ExtendedTrustManager) {
            return new TrustManagerDelegate((X509ExtendedTrustManager)tm, trustStrategy);
        }
        return tm;
    }

    public SSLContextBuilder loadKeyMaterial(KeyStore keystore, char[] keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, keyPassword);
        KeyManager[] kms = kmfactory.getKeyManagers();
        if (kms != null) {
            Collections.addAll(this.keyManagers, kms);
        }
        return this;
    }

    protected void initSSLContext(SSLContext sslContext, Collection<KeyManager> keyManagers, Collection<TrustManager> trustManagers) throws KeyManagementException {
        sslContext.init(!keyManagers.isEmpty() ? keyManagers.toArray(new KeyManager[0]) : null, !trustManagers.isEmpty() ? trustManagers.toArray(new TrustManager[0]) : null, null);
    }

    public SSLContext build() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        this.initSSLContext(sslContext, this.keyManagers, this.trustManagers);
        return sslContext;
    }

    public String toString() {
        return "[keyManagers=" + String.valueOf(this.keyManagers) + ", trustManagers=" + String.valueOf(this.trustManagers) + "]";
    }

    static class TrustManagerDelegate
    extends X509ExtendedTrustManager {
        private final X509ExtendedTrustManager trustManager;
        private final TrustStrategy trustStrategy;

        TrustManagerDelegate(X509ExtendedTrustManager trustManager, TrustStrategy trustStrategy) {
            this.trustManager = trustManager;
            this.trustStrategy = trustStrategy;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (!this.trustStrategy.isTrusted(chain, authType)) {
                this.trustManager.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            this.trustManager.checkClientTrusted(chain, authType, socket);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            if (!this.trustStrategy.isTrusted(chain, authType, socket)) {
                this.trustManager.checkServerTrusted(chain, authType, socket);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            this.trustManager.checkClientTrusted(chain, authType, engine);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            if (!this.trustStrategy.isTrusted(chain, authType, engine)) {
                this.trustManager.checkServerTrusted(chain, authType, engine);
            }
        }
    }
}

