/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Base64;
import java.util.Collections;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.TypeFactory;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ContentEncodingValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ContentEncodingValidator.class);
    private final String contentEncoding;

    public ContentEncodingValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.CONTENT_ENCODING, validationContext);
        this.contentEncoding = schemaNode.textValue();
    }

    private boolean matches(String value) {
        if ("base64".equals(this.contentEncoding)) {
            try {
                Base64.getDecoder().decode(value);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        ContentEncodingValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        if (nodeType != JsonType.STRING) {
            return Collections.emptySet();
        }
        if (this.collectAnnotations(executionContext)) {
            this.putAnnotation(executionContext, annotation -> annotation.instanceLocation(instanceLocation).value(this.contentEncoding));
        }
        if (!this.matches(node.asText())) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(this.contentEncoding)).build());
        }
        return Collections.emptySet();
    }
}

