/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.ThresholdMixin;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.utils.JsonNodeUtil;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class MinimumValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MinimumValidator.class);
    private static final String PROPERTY_EXCLUSIVE_MINIMUM = "exclusiveMinimum";
    private boolean excludeEqual = false;
    private final ThresholdMixin typedMinimum;

    public MinimumValidator(String schemaPath, final JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MINIMUM, validationContext);
        if (!schemaNode.isNumber()) {
            throw new JsonSchemaException("minimum value is not a number");
        }
        JsonNode exclusiveMinimumNode = this.getParentSchema().getSchemaNode().get(PROPERTY_EXCLUSIVE_MINIMUM);
        if (exclusiveMinimumNode != null && exclusiveMinimumNode.isBoolean()) {
            this.excludeEqual = exclusiveMinimumNode.booleanValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
        final String minimumText = schemaNode.asText();
        if ((schemaNode.isLong() || schemaNode.isInt()) && JsonType.INTEGER.toString().equals(this.getNodeFieldType())) {
            final long lmin = schemaNode.asLong();
            this.typedMinimum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    if (node.isBigInteger()) {
                        int compare = node.bigIntegerValue().compareTo(new BigInteger(minimumText));
                        return compare < 0 || MinimumValidator.this.excludeEqual && compare == 0;
                    }
                    if (node.isTextual()) {
                        BigDecimal min2 = new BigDecimal(minimumText);
                        BigDecimal value = new BigDecimal(node.asText());
                        int compare = value.compareTo(min2);
                        return compare < 0 || MinimumValidator.this.excludeEqual && compare == 0;
                    }
                    long val = node.asLong();
                    return lmin > val || MinimumValidator.this.excludeEqual && lmin == val;
                }

                @Override
                public String thresholdValue() {
                    return String.valueOf(lmin);
                }
            };
        } else {
            this.typedMinimum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    if (schemaNode.isDouble() && schemaNode.doubleValue() == Double.NEGATIVE_INFINITY) {
                        return false;
                    }
                    if (schemaNode.isDouble() && schemaNode.doubleValue() == Double.POSITIVE_INFINITY) {
                        return true;
                    }
                    if (node.isDouble() && node.doubleValue() == Double.NEGATIVE_INFINITY) {
                        return true;
                    }
                    if (node.isDouble() && node.doubleValue() == Double.POSITIVE_INFINITY) {
                        return false;
                    }
                    BigDecimal min2 = new BigDecimal(minimumText);
                    BigDecimal value = new BigDecimal(node.asText());
                    int compare = value.compareTo(min2);
                    return compare < 0 || MinimumValidator.this.excludeEqual && compare == 0;
                }

                @Override
                public String thresholdValue() {
                    return minimumText;
                }
            };
        }
        this.validationContext = validationContext;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        MinimumValidator.debug(logger, node, rootNode, at);
        if (!JsonNodeUtil.isNumber(node, this.validationContext.getConfig())) {
            return Collections.emptySet();
        }
        if (this.typedMinimum.crossesThreshold(node)) {
            return Collections.singleton(this.buildValidationMessage(at, this.typedMinimum.thresholdValue()));
        }
        return Collections.emptySet();
    }
}

