/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformationContextImpl;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;

public class AliasOperationTransformer
implements CombinedTransformer {
    private final AddressTransformer transformer;

    protected AliasOperationTransformer(AddressTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode original) throws OperationFailedException {
        ModelNode operation = original.clone();
        PathAddress transformedAddress = this.transformer.transformAddress(address);
        operation.get("address").set(transformedAddress.toModelNode());
        String operationName = operation.get("operation").asString();
        OperationTransformer aliasTransformer = context.getTarget().resolveTransformer(context, transformedAddress, operationName);
        if (aliasTransformer != null) {
            return aliasTransformer.transformOperation(context, transformedAddress, operation);
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }

    @Override
    public void transformResource(ResourceTransformationContext currentCtx, PathAddress address, Resource resource) throws OperationFailedException {
        PathAddress transformedAddress = this.transformer.transformAddress(address);
        ResourceTransformationContext context = ResourceTransformationContextImpl.createAliasContext(transformedAddress, currentCtx);
        ResourceTransformer aliasTransformer = context.getTarget().resolveTransformer(null, transformedAddress);
        if (aliasTransformer != null) {
            aliasTransformer.transformResource(context, address, resource);
        } else {
            ResourceTransformer.DEFAULT.transformResource(context, transformedAddress, resource);
        }
    }

    public static AliasOperationTransformer replaceLastElement(final PathElement element) {
        return AliasOperationTransformer.create(new AddressTransformer(){

            @Override
            public PathAddress transformAddress(PathAddress original) {
                PathAddress address = original.subAddress(0, original.size() - 1);
                return address.append(element);
            }
        });
    }

    public static AliasOperationTransformer create(AddressTransformer transformer) {
        return new AliasOperationTransformer(transformer);
    }

    public static interface AddressTransformer {
        public PathAddress transformAddress(PathAddress var1);
    }
}

