/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;

public class ExpressionResolverImpl
implements ExpressionResolver {
    protected ExpressionResolverImpl() {
    }

    @Override
    public final ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.resolveExpressionsRecursively(node);
    }

    private ModelNode resolveExpressionsRecursively(ModelNode node) throws OperationFailedException {
        ModelNode resolved;
        if (!node.isDefined()) {
            return node;
        }
        ModelType type = node.getType();
        if (type == ModelType.EXPRESSION) {
            resolved = this.resolveExpressionType(node, false);
        } else if (type == ModelType.OBJECT) {
            resolved = node.clone();
            for (Property prop : resolved.asPropertyList()) {
                resolved.get(prop.getName()).set(this.resolveExpressionsRecursively(prop.getValue()));
            }
        } else if (type == ModelType.LIST) {
            resolved = node.clone();
            ModelNode list = new ModelNode();
            for (ModelNode current : resolved.asList()) {
                list.add(this.resolveExpressionsRecursively(current));
            }
            resolved = list;
        } else if (type == ModelType.PROPERTY) {
            resolved = node.clone();
            resolved.set(resolved.asProperty().getName(), this.resolveExpressionsRecursively(resolved.asProperty().getValue()));
        } else {
            resolved = node;
        }
        return resolved;
    }

    protected void resolvePluggableExpression(ModelNode node) throws OperationFailedException {
    }

    private ModelNode resolveExpressionType(ModelNode expressionType, boolean ignoreDMRResolutionFailure) throws OperationFailedException {
        ModelNode resolved = expressionType.clone();
        this.resolvePluggableExpression(resolved);
        if (resolved.getType() == ModelType.EXPRESSION) {
            String resolvedString;
            String unresolvedString = expressionType.asString();
            if (!unresolvedString.equals(resolvedString = (resolved = ExpressionResolverImpl.resolveStandardExpression(resolved, ignoreDMRResolutionFailure)).asString())) {
                resolved = this.convertAndResolve(resolvedString);
            }
        } else {
            resolved = this.convertAndResolve(resolved.asString());
        }
        return resolved;
    }

    private ModelNode convertAndResolve(String possibleExpression) throws OperationFailedException {
        if (EXPRESSION_PATTERN.matcher(possibleExpression).matches()) {
            ModelNode expression = new ModelNode();
            expression.set(new ValueExpression(possibleExpression));
            return this.resolveExpressionType(expression, true);
        }
        return new ModelNode(possibleExpression);
    }

    private static ModelNode resolveStandardExpression(ModelNode unresolved, boolean ignoreUnresolvable) throws OperationFailedException {
        try {
            return unresolved.resolve();
        }
        catch (SecurityException e) {
            throw new OperationFailedException(ControllerMessages.MESSAGES.noPermissionToResolveExpression(unresolved, e));
        }
        catch (IllegalStateException e) {
            if (ignoreUnresolvable) {
                return new ModelNode(unresolved.asString());
            }
            throw new OperationFailedException(ControllerMessages.MESSAGES.cannotResolveExpression(unresolved, e));
        }
    }
}

