/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.common;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.GalleonFeaturePack;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.ScanArguments;
import org.wildfly.glow.ScanResults;
import org.wildfly.glow.error.ErrorLevel;
import org.wildfly.glow.error.IdentifiedError;
import org.wildfly.plugin.common.GlowMavenMessageWriter;
import org.wildfly.plugin.provision.GlowConfig;
import org.wildfly.plugin.tools.GalleonUtils;

public class Utils {
    private static final Pattern EMPTY_STRING = Pattern.compile("^$|\\s+");
    private static final Pattern WHITESPACE_IF_NOT_QUOTED = Pattern.compile("(\\S+\"[^\"]+\")|\\S+");
    public static final String WILDFLY_DEFAULT_DIR = "server";

    public static boolean isNotNullOrEmpty(CharSequence seq) {
        return seq != null && !EMPTY_STRING.matcher(seq).matches();
    }

    public static boolean isNotNullOrEmpty(Object[] array) {
        return array != null && array.length > 0;
    }

    public static String toString(Iterable<?> iterable, CharSequence delimiter) {
        StringBuilder result = new StringBuilder();
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            result.append(iterator.next());
            if (!iterator.hasNext()) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static List<String> splitArguments(CharSequence arguments) {
        ArrayList<String> args = new ArrayList<String>();
        Matcher m = WHITESPACE_IF_NOT_QUOTED.matcher(arguments);
        while (m.find()) {
            String value = m.group();
            if (value.isEmpty()) continue;
            args.add(value);
        }
        return args;
    }

    public static ScanResults scanDeployment(GlowConfig discoverProvisioningInfo, List<String> layers, List<String> excludedLayers, List<GalleonFeaturePack> featurePacks, boolean dryRun, Log log, List<Path> deploymentContents, MavenRepoManager artifactResolver, Path outputFolder, GalleonBuilder pm, Map<String, String> galleonOptions, String layersConfigurationFileName) throws Exception {
        return Utils.scanDeployment(discoverProvisioningInfo, layers, excludedLayers, featurePacks, dryRun, log, deploymentContents, artifactResolver, outputFolder, pm, galleonOptions, layersConfigurationFileName, layersConfigurationFileName, false);
    }

    public static ScanResults scanDeployment(GlowConfig discoverProvisioningInfo, List<String> layers, List<String> excludedLayers, List<GalleonFeaturePack> featurePacks, boolean dryRun, Log log, List<Path> deploymentContents, MavenRepoManager artifactResolver, Path outputFolder, GalleonBuilder pm, Map<String, String> galleonOptions, String layersConfigurationFileName, String provisionedConfigFileName, boolean bootableJar) throws Exception {
        ScanResults results;
        if (!layers.isEmpty()) {
            throw new MojoExecutionException("layers must be empty when enabling glow");
        }
        if (!excludedLayers.isEmpty()) {
            throw new MojoExecutionException("excluded layers must be empty when enabling glow");
        }
        if (deploymentContents.isEmpty() && !discoverProvisioningInfo.isIgnoreDeployment()) {
            throw new MojoExecutionException("A deployment is expected when enabling glow layer discovery");
        }
        if (discoverProvisioningInfo.isIgnoreDeployment()) {
            log.warn((CharSequence)"The deployment will be not analyzed, WildFly Glow will produce a server based on configured add-ons and the default base layer.");
        }
        Path inProvisioningFile = null;
        Path glowOutputFolder = outputFolder.resolve("glow-scan");
        Files.createDirectories(glowOutputFolder, new FileAttribute[0]);
        if (!featurePacks.isEmpty()) {
            GalleonProvisioningConfig in = GalleonUtils.buildConfig((GalleonBuilder)pm, featurePacks, layers, excludedLayers, galleonOptions, (String)layersConfigurationFileName, (String)provisionedConfigFileName);
            inProvisioningFile = glowOutputFolder.resolve("glow-in-provisioning.xml");
            try (Provisioning p = pm.newProvisioningBuilder(in).build();){
                p.storeProvisioningConfig(in, inProvisioningFile);
            }
        }
        Arguments arguments = discoverProvisioningInfo.toArguments(deploymentContents, inProvisioningFile, layersConfigurationFileName);
        log.info((CharSequence)"Glow is scanning... ");
        GlowMavenMessageWriter writer = new GlowMavenMessageWriter(log);
        try {
            results = GlowSession.scan((MavenRepoManager)artifactResolver, (ScanArguments)arguments, (GlowMessageWriter)writer, (boolean)bootableJar);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getLocalizedMessage(), ex);
        }
        log.info((CharSequence)"Glow scanning DONE.");
        try {
            results.outputInformation((GlowMessageWriter)writer);
        }
        catch (Exception ex) {
            results.close();
            throw new MojoExecutionException(ex.getLocalizedMessage(), ex);
        }
        if (!dryRun) {
            results.outputConfig(glowOutputFolder, null);
        }
        if (results.getErrorSession().hasErrors()) {
            if (discoverProvisioningInfo.isFailsOnError()) {
                for (IdentifiedError error : results.getErrorSession().getErrors()) {
                    if (error.getErrorLevel() != ErrorLevel.ERROR) continue;
                    results.close();
                    throw new MojoExecutionException("Error detected by WildFly Glow. Aborting.");
                }
            }
            log.warn((CharSequence)"Some errors have been identified, check logs.");
        }
        return results;
    }
}

