/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.core.launcher.CliCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.plugin.cli.BaseCommandConfiguration;
import org.wildfly.plugin.cli.ScriptWriter;
import org.wildfly.plugin.common.Environment;
import org.wildfly.plugin.common.StandardOutput;

public abstract class AbstractCommandExecutor<T extends BaseCommandConfiguration>
extends AbstractLogEnabled {
    public abstract void execute(T var1, MavenRepoManager var2) throws MojoFailureException, MojoExecutionException;

    protected abstract int executeInNewProcess(T var1, Path var2, StandardOutput var3) throws MojoExecutionException, IOException;

    protected void executeInNewProcess(T config) throws MojoExecutionException {
        if (!((BaseCommandConfiguration)config).getCommands().isEmpty()) {
            Path scriptFile = null;
            try {
                scriptFile = ScriptWriter.create(config);
                this.executeInNewProcess(config, scriptFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed execute commands.", (Exception)e);
            }
            finally {
                if (scriptFile != null) {
                    try {
                        Files.deleteIfExists(scriptFile);
                    }
                    catch (IOException e) {
                        this.getLogger().debug("Failed to deleted CLI script file: " + String.valueOf(scriptFile), (Throwable)e);
                    }
                }
            }
        }
        if (!((BaseCommandConfiguration)config).getScripts().isEmpty()) {
            for (Path script : ((BaseCommandConfiguration)config).getScripts()) {
                this.executeInNewProcess(config, script);
            }
        }
    }

    private void executeInNewProcess(T config, Path scriptFile) throws MojoExecutionException {
        this.getLogger().debug("Executing CLI scripts");
        try {
            StandardOutput out = StandardOutput.parse(((BaseCommandConfiguration)config).getStdout(), false, ((BaseCommandConfiguration)config).isAppend());
            int exitCode = this.executeInNewProcess(config, scriptFile, out);
            if (exitCode != 0) {
                StringBuilder msg = new StringBuilder("Failed to execute commands: ");
                switch (out.getTarget()) {
                    case COLLECTING: {
                        msg.append(out);
                        break;
                    }
                    case FILE: {
                        Path stdoutPath = out.getStdoutPath();
                        msg.append("See ").append(stdoutPath).append(" for full details of failure.").append(System.lineSeparator());
                        List<String> lines = Files.readAllLines(stdoutPath);
                        lines.subList(Math.max(lines.size() - 4, 0), lines.size()).forEach(line -> msg.append((String)line).append(System.lineSeparator()));
                        break;
                    }
                    case SYSTEM_ERR: 
                    case SYSTEM_OUT: 
                    case INHERIT: {
                        msg.append("See previous messages for failure messages.");
                        break;
                    }
                    default: {
                        msg.append("Reason unknown");
                    }
                }
                if (((BaseCommandConfiguration)config).isFailOnError()) {
                    throw new MojoExecutionException(msg.toString());
                }
                this.getLogger().warn(msg.toString());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to execute scripts.", (Exception)e);
        }
    }

    protected CliCommandBuilder createCommandBuilder(T config, Path scriptFile) throws IOException {
        Logger log = this.getLogger();
        CliCommandBuilder builder = CliCommandBuilder.of((Path)((BaseCommandConfiguration)config).getJBossHome()).setScriptFile(scriptFile).addCliArguments(((BaseCommandConfiguration)config).getCLIArguments()).setTimeout(((BaseCommandConfiguration)config).getTimeout() * 1000);
        if (Environment.isModularJvm(builder.getJavaHome())) {
            builder.addJavaOptions(Environment.getModularJvmArguments());
        }
        Map<String, String> systemProperties = ((BaseCommandConfiguration)config).getSystemProperties();
        systemProperties.forEach((key, value) -> builder.addJavaOption(String.format("-D%s=%s", key, value)));
        if (systemProperties.containsKey("module.path")) {
            String[] modulePaths = systemProperties.get("module.path").split(File.pathSeparator);
            builder.setModuleDirs(modulePaths);
        }
        Properties properties = new Properties();
        for (Path file : ((BaseCommandConfiguration)config).getPropertiesFiles()) {
            AbstractCommandExecutor.parseProperties(file, properties);
        }
        for (String key2 : properties.stringPropertyNames()) {
            builder.addJavaOption(String.format("-D%s=%s", key2, properties.getProperty(key2)));
        }
        Collection<String> javaOpts = ((BaseCommandConfiguration)config).getJvmOptions();
        if (log.isDebugEnabled() && !javaOpts.isEmpty()) {
            log.debug("java opts: " + String.valueOf(javaOpts));
        }
        for (String opt : javaOpts) {
            if (opt.trim().isEmpty()) continue;
            builder.addJavaOption(opt);
        }
        if (((BaseCommandConfiguration)config).isExpressionResolved()) {
            builder.addCliArgument("--resolve-parameter-values");
        }
        if (log.isDebugEnabled()) {
            log.debug("process parameters: " + String.valueOf(builder.build()));
        }
        return builder;
    }

    protected int launchProcess(CliCommandBuilder builder, T config, StandardOutput stdout) throws MojoExecutionException, IOException {
        Logger log = this.getLogger();
        Launcher launcher = Launcher.of((CommandBuilder)builder).addEnvironmentVariable("JBOSS_HOME", ((BaseCommandConfiguration)config).getJBossHome().toString()).setRedirectErrorStream(true);
        stdout.getRedirect().ifPresent(arg_0 -> ((Launcher)launcher).redirectOutput(arg_0));
        Process process = launcher.launch();
        Optional<Thread> consoleConsumer = stdout.startConsumer(process);
        try {
            int n = process.waitFor();
            return n;
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Failed to run goal execute-commands in forked process.", (Exception)e);
        }
        finally {
            if (process.isAlive()) {
                process.destroyForcibly();
            }
            consoleConsumer.ifPresent(Thread::interrupt);
        }
    }

    static void parseProperties(Path file, Properties properties) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            properties.load(reader);
        }
    }
}

