/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpclient.impl;

import com.webpieces.hpack.api.dto.Http2Response;
import com.webpieces.http2engine.api.ResponseHandler;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2engine.api.error.ConnectionCancelled;
import com.webpieces.http2engine.api.error.ConnectionFailure;
import com.webpieces.http2engine.api.error.ShutdownStream;
import com.webpieces.http2parser.api.dto.CancelReason;
import com.webpieces.http2parser.api.dto.DataFrame;
import com.webpieces.http2parser.api.dto.error.CancelReasonCode;
import com.webpieces.http2parser.api.dto.error.ConnectionException;
import com.webpieces.http2parser.api.dto.lib.StreamMsg;
import java.util.concurrent.CompletableFuture;
import org.webpieces.http2translations.api.Http1_1ToHttp2;
import org.webpieces.httpclient.api.DataWriter;
import org.webpieces.httpclient.api.HttpResponseListener;
import org.webpieces.httpparser.api.dto.HttpData;
import org.webpieces.httpparser.api.dto.HttpResponse;

public class ResponseListener
implements HttpResponseListener {
    private ResponseHandler responseListener;
    private String logId;

    public ResponseListener(String logId, ResponseHandler responseListener) {
        this.logId = logId;
        this.responseListener = responseListener;
    }

    public CompletableFuture<DataWriter> incomingResponse(HttpResponse resp, boolean isComplete) {
        Http2Response r = Http1_1ToHttp2.responseToHeaders((HttpResponse)resp);
        return this.responseListener.process(r).thenApply(w -> new DataWriterImpl((StreamWriter)w));
    }

    public void failure(Throwable e) {
        ConnectionFailure connCancelled = new ConnectionFailure(new ConnectionException(CancelReasonCode.BUG, this.logId, 0, "Failure from connection", e));
        this.responseListener.cancel((CancelReason)new ShutdownStream(0, (ConnectionCancelled)connCancelled));
    }

    private class DataWriterImpl
    implements DataWriter {
        private StreamWriter writer;

        public DataWriterImpl(StreamWriter writer) {
            this.writer = writer;
        }

        public CompletableFuture<Void> incomingData(HttpData chunk) {
            DataFrame data = Http1_1ToHttp2.translateData((HttpData)chunk);
            return this.writer.processPiece((StreamMsg)data);
        }
    }
}

