/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpclient.impl;

import com.webpieces.hpack.api.dto.Http2Request;
import com.webpieces.http2engine.api.ResponseHandler;
import com.webpieces.http2engine.api.StreamHandle;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2parser.api.dto.CancelReason;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.webpieces.http2client.api.Http2Socket;
import org.webpieces.http2client.api.dto.FullRequest;
import org.webpieces.http2client.api.dto.FullResponse;
import org.webpieces.http2translations.api.Http2ToHttp1_1;
import org.webpieces.httpclient.api.HttpDataWriter;
import org.webpieces.httpclient.api.HttpFullRequest;
import org.webpieces.httpclient.api.HttpResponseListener;
import org.webpieces.httpclient.api.HttpSocket;
import org.webpieces.httpclient.impl.ResponseListener;
import org.webpieces.httpclient.impl.StreamWriterImpl;
import org.webpieces.httpclient.impl.Translations2;
import org.webpieces.httpparser.api.dto.HttpRequest;

public class Http2SocketImpl
implements Http2Socket {
    private HttpSocket socket1_1;

    public Http2SocketImpl(HttpSocket socket1_1) {
        this.socket1_1 = socket1_1;
    }

    public CompletableFuture<Void> connect(InetSocketAddress addr) {
        return this.socket1_1.connect(addr);
    }

    public StreamHandle openStream() {
        return new StreamImpl();
    }

    public CompletableFuture<FullResponse> send(FullRequest request) {
        HttpFullRequest req = Translations2.translate(request);
        return this.socket1_1.send(req).thenApply(r -> Translations2.translate(r));
    }

    public CompletableFuture<Void> close() {
        return this.socket1_1.close();
    }

    public CompletableFuture<Void> sendPing() {
        throw new UnsupportedOperationException("Http1.1 does not support ping");
    }

    private class StreamImpl
    implements StreamHandle {
        private StreamImpl() {
        }

        public CompletableFuture<StreamWriter> process(Http2Request request, ResponseHandler responseListener) {
            HttpRequest req = Http2ToHttp1_1.translateRequest((Http2Request)request);
            return Http2SocketImpl.this.socket1_1.send(req, (HttpResponseListener)new ResponseListener(Http2SocketImpl.this.socket1_1 + "", responseListener)).thenApply(s -> new StreamWriterImpl((HttpDataWriter)s, req));
        }

        public CompletableFuture<Void> cancel(CancelReason payload) {
            throw new UnsupportedOperationException("In http1_1, you can only just close the socket.  call socket.close instead to cancel all requests");
        }
    }
}

