/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.property.StreamingPropertyValue;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.artifactThumbnails.ArtifactThumbnailRepository;
import org.visallo.core.model.properties.MediaVisalloProperties;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.VisalloResponse;

public class VertexVideoPreviewImage
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(VertexVideoPreviewImage.class);
    private final Graph graph;
    private final ArtifactThumbnailRepository artifactThumbnailRepository;

    @Inject
    public VertexVideoPreviewImage(Graph graph, ArtifactThumbnailRepository artifactThumbnailRepository) {
        this.graph = graph;
        this.artifactThumbnailRepository = artifactThumbnailRepository;
    }

    @Handle
    public void handle(@Required(name="graphVertexId") String graphVertexId, @Optional(name="width") Integer width, User user, Authorizations authorizations, VisalloResponse response) throws Exception {
        block54: {
            Vertex artifactVertex = this.graph.getVertex(graphVertexId, authorizations);
            if (artifactVertex == null) {
                throw new VisalloResourceNotFoundException("Could not find vertex with id: " + graphVertexId);
            }
            int[] boundaryDims = new int[]{200 * ArtifactThumbnailRepository.FRAMES_PER_PREVIEW, 200};
            if (width != null) {
                boundaryDims[0] = width * ArtifactThumbnailRepository.FRAMES_PER_PREVIEW;
                boundaryDims[1] = width;
                response.setContentType("image/jpeg");
                response.addHeader("Content-Disposition", "inline; filename=videoPreview" + boundaryDims[0] + ".jpg");
                response.setMaxAge(3600);
                byte[] thumbnailData = this.artifactThumbnailRepository.getThumbnailData(artifactVertex.getId(), "video-preview", boundaryDims[0], boundaryDims[1], user);
                if (thumbnailData != null) {
                    LOGGER.debug("Cache hit for: %s (video-preview) %d x %d", new Object[]{artifactVertex.getId(), boundaryDims[0], boundaryDims[1]});
                    try (OutputStream out = response.getOutputStream();){
                        out.write(thumbnailData);
                    }
                    return;
                }
            }
            Property videoPreviewImage = MediaVisalloProperties.VIDEO_PREVIEW_IMAGE.getProperty((Element)artifactVertex);
            StreamingPropertyValue videoPreviewImageValue = (StreamingPropertyValue)MediaVisalloProperties.VIDEO_PREVIEW_IMAGE.getPropertyValue((Element)artifactVertex);
            if (videoPreviewImageValue == null) {
                LOGGER.warn("Could not find video preview image for artifact: %s", new Object[]{artifactVertex.getId()});
                response.respondWithNotFound();
                return;
            }
            try (InputStream in = videoPreviewImageValue.getInputStream();){
                if (width != null) {
                    LOGGER.info("Cache miss for: %s (video-preview) %d x %d", new Object[]{artifactVertex.getId(), boundaryDims[0], boundaryDims[1]});
                    response.setContentType("image/jpeg");
                    response.addHeader("Content-Disposition", "inline; filename=videoPreview" + boundaryDims[0] + ".jpg");
                    response.setMaxAge(3600);
                    byte[] thumbnailData = this.artifactThumbnailRepository.createThumbnail(artifactVertex, videoPreviewImage.getKey(), "video-preview", in, boundaryDims, user).getData();
                    try (OutputStream out = response.getOutputStream();){
                        out.write(thumbnailData);
                        break block54;
                    }
                }
                response.setContentType("image/png");
                try (OutputStream out = response.getOutputStream();){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
        }
    }
}

