/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Required;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.EdgeBuilder;
import org.vertexium.Element;
import org.vertexium.ElementBuilder;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.util.IterableUtils;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.ImageTransform;
import org.visallo.core.util.ImageTransformExtractor;
import org.visallo.core.util.RowKeyHelper;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.VisibilityJson;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;

public class VertexUploadImage
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(VertexUploadImage.class);
    private static final String SOURCE_UPLOAD = "User Upload";
    private static final String PROCESS = VertexUploadImage.class.getName();
    private static final String MULTI_VALUE_KEY = VertexUploadImage.class.getName();
    private final Graph graph;
    private final OntologyRepository ontologyRepository;
    private final WorkQueueRepository workQueueRepository;
    private final VisibilityTranslator visibilityTranslator;
    private final WorkspaceRepository workspaceRepository;
    private final String clockwiseRotationIri;
    private final String yAxisFlippedIri;
    private final String conceptIri;
    private final String entityHasImageIri;

    @Inject
    public VertexUploadImage(Graph graph, OntologyRepository ontologyRepository, WorkQueueRepository workQueueRepository, VisibilityTranslator visibilityTranslator, WorkspaceRepository workspaceRepository) {
        this.graph = graph;
        this.ontologyRepository = ontologyRepository;
        this.workQueueRepository = workQueueRepository;
        this.visibilityTranslator = visibilityTranslator;
        this.workspaceRepository = workspaceRepository;
        this.conceptIri = ontologyRepository.getRequiredConceptIRIByIntent("entityImage");
        this.entityHasImageIri = ontologyRepository.getRequiredRelationshipIRIByIntent("entityHasImage");
        this.yAxisFlippedIri = ontologyRepository.getRequiredPropertyIRIByIntent("media.yAxisFlipped");
        this.clockwiseRotationIri = ontologyRepository.getRequiredPropertyIRIByIntent("media.clockwiseRotation");
    }

    @Handle
    public ClientApiElement handle(HttpServletRequest request, @Required(name="graphVertexId") String graphVertexId, @ActiveWorkspaceId String workspaceId, User user, Authorizations authorizations) throws Exception {
        ArrayList files = Lists.newArrayList((Iterable)request.getParts());
        Concept concept = this.ontologyRepository.getConceptByIRI(this.conceptIri);
        Preconditions.checkNotNull((Object)concept, (Object)("Could not find image concept: " + this.conceptIri));
        if (files.size() != 1) {
            throw new RuntimeException("Wrong number of uploaded files. Expected 1 got " + files.size());
        }
        Part file = (Part)files.get(0);
        Workspace workspace = this.workspaceRepository.findById(workspaceId, user);
        Vertex entityVertex = this.graph.getVertex(graphVertexId, authorizations);
        if (entityVertex == null) {
            throw new VisalloResourceNotFoundException(String.format("Could not find associated entity vertex for id: %s", graphVertexId));
        }
        ExistingElementMutation entityVertexMutation = entityVertex.prepareMutation();
        VisibilityJson visibilityJson = this.getVisalloVisibility(entityVertex, workspaceId);
        Visibility visibility = this.visibilityTranslator.toVisibility(visibilityJson).getVisibility();
        Metadata metadata = new Metadata();
        VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(metadata, (Object)visibilityJson, this.visibilityTranslator.getDefaultVisibility());
        String title = this.imageTitle(entityVertex);
        ElementBuilder<Vertex> artifactVertexBuilder = this.convertToArtifact(file, title, visibilityJson, metadata, user, visibility);
        Vertex artifactVertex = (Vertex)artifactVertexBuilder.save(authorizations);
        this.graph.flush();
        entityVertexMutation.setProperty(VisalloProperties.ENTITY_IMAGE_VERTEX_ID.getPropertyName(), (Object)artifactVertex.getId(), metadata, visibility);
        entityVertex = (Vertex)entityVertexMutation.save(authorizations);
        this.graph.flush();
        List existingEdges = IterableUtils.toList((Iterable)entityVertex.getEdges(artifactVertex, Direction.BOTH, this.entityHasImageIri, authorizations));
        if (existingEdges.size() == 0) {
            EdgeBuilder edgeBuilder = this.graph.prepareEdge(entityVertex, artifactVertex, this.entityHasImageIri, visibility);
            Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
            VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation)edgeBuilder, (Object)visibilityJson, defaultVisibility);
            VisalloProperties.MODIFIED_DATE.setProperty((ElementMutation)edgeBuilder, (Object)new Date(), defaultVisibility);
            VisalloProperties.MODIFIED_BY.setProperty((ElementMutation)edgeBuilder, (Object)user.getUserId(), defaultVisibility);
            edgeBuilder.save(authorizations);
        }
        this.workspaceRepository.updateEntityOnWorkspace(workspace, artifactVertex.getId(), user);
        this.workspaceRepository.updateEntityOnWorkspace(workspace, entityVertex.getId(), user);
        this.graph.flush();
        this.workQueueRepository.pushElement((Element)artifactVertex, Priority.HIGH);
        this.workQueueRepository.pushGraphPropertyQueue((Element)artifactVertex, null, VisalloProperties.RAW.getPropertyName(), workspaceId, visibilityJson.getSource(), Priority.HIGH);
        this.workQueueRepository.pushElementImageQueue((Element)entityVertex, null, VisalloProperties.ENTITY_IMAGE_VERTEX_ID.getPropertyName(), Priority.HIGH);
        return ClientApiConverter.toClientApi((Element)entityVertex, (String)workspaceId, (Authorizations)authorizations);
    }

    private String imageTitle(Vertex entityVertex) {
        Object title;
        Property titleProperty = VisalloProperties.TITLE.getFirstProperty((Element)entityVertex);
        if (titleProperty == null) {
            String conceptTypeProperty = VisalloProperties.CONCEPT_TYPE.getPropertyName();
            String vertexConceptType = (String)entityVertex.getProperty(conceptTypeProperty).getValue();
            Concept concept = this.ontologyRepository.getConceptByIRI(vertexConceptType);
            title = concept.getDisplayName();
        } else {
            title = titleProperty.getValue();
        }
        return String.format("Image of %s", title.toString());
    }

    private VisibilityJson getVisalloVisibility(Vertex entityVertex, String workspaceId) {
        String visibilitySource;
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue((Element)entityVertex);
        if (visibilityJson == null) {
            visibilityJson = new VisibilityJson();
        }
        if ((visibilitySource = visibilityJson.getSource()) == null) {
            visibilitySource = "";
        }
        return VisibilityJson.updateVisibilitySourceAndAddWorkspaceId((VisibilityJson)visibilityJson, (String)visibilitySource, (String)workspaceId);
    }

    protected ElementBuilder<Vertex> convertToArtifact(Part file, String title, VisibilityJson visibilityJson, Metadata metadata, User user, Visibility visibility) throws IOException {
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        InputStream fileInputStream = file.getInputStream();
        byte[] rawContent = IOUtils.toByteArray((InputStream)fileInputStream);
        LOGGER.debug("Uploaded file raw content byte length: %d", new Object[]{rawContent.length});
        String fileName = file.getName();
        String fileRowKey = RowKeyHelper.buildSHA256KeyString((byte[])rawContent);
        LOGGER.debug("Generated row key: %s", new Object[]{fileRowKey});
        StreamingPropertyValue rawValue = new StreamingPropertyValue((InputStream)new ByteArrayInputStream(rawContent), byte[].class);
        rawValue.searchIndex(false);
        rawValue.store(true);
        VertexBuilder vertexBuilder = this.graph.prepareVertex(visibility);
        VisalloProperties.CONCEPT_TYPE.setProperty((ElementMutation)vertexBuilder, (Object)this.conceptIri, defaultVisibility);
        VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation)vertexBuilder, (Object)visibilityJson, defaultVisibility);
        VisalloProperties.MODIFIED_BY.setProperty((ElementMutation)vertexBuilder, (Object)user.getUserId(), defaultVisibility);
        VisalloProperties.MODIFIED_DATE.setProperty((ElementMutation)vertexBuilder, (Object)new Date(), defaultVisibility);
        VisalloProperties.TITLE.addPropertyValue((ElementMutation)vertexBuilder, MULTI_VALUE_KEY, (Object)title, metadata, visibility);
        VisalloProperties.FILE_NAME.addPropertyValue((ElementMutation)vertexBuilder, MULTI_VALUE_KEY, (Object)fileName, metadata, visibility);
        VisalloProperties.RAW.setProperty((ElementMutation)vertexBuilder, (Object)rawValue, metadata, visibility);
        VisalloProperties.SOURCE.addPropertyValue((ElementMutation)vertexBuilder, MULTI_VALUE_KEY, (Object)SOURCE_UPLOAD, metadata, visibility);
        VisalloProperties.PROCESS.addPropertyValue((ElementMutation)vertexBuilder, MULTI_VALUE_KEY, (Object)PROCESS, metadata, visibility);
        ImageTransform imageTransform = ImageTransformExtractor.getImageTransform((byte[])rawContent);
        vertexBuilder.setProperty(this.yAxisFlippedIri, (Object)imageTransform.isYAxisFlipNeeded(), metadata, visibility);
        vertexBuilder.setProperty(this.clockwiseRotationIri, (Object)imageTransform.getCWRotationNeeded(), metadata, visibility);
        return vertexBuilder;
    }
}

