/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.graph.GraphRepository;
import org.visallo.core.model.graph.VisibilityAndElementMutation;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.ACLProvider;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.VertexiumMetadataUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiSourceInfo;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;
import org.visallo.web.parameterProviders.JustificationText;
import org.visallo.web.routes.SetPropertyBase;
import org.visallo.web.util.VisibilityValidator;

public class VertexSetProperty
extends SetPropertyBase
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(VertexSetProperty.class);
    private final OntologyRepository ontologyRepository;
    private final WorkspaceRepository workspaceRepository;
    private final WorkQueueRepository workQueueRepository;
    private final GraphRepository graphRepository;
    private final ACLProvider aclProvider;
    private final boolean autoPublishComments;

    @Inject
    public VertexSetProperty(OntologyRepository ontologyRepository, Graph graph, VisibilityTranslator visibilityTranslator, WorkspaceRepository workspaceRepository, WorkQueueRepository workQueueRepository, GraphRepository graphRepository, ACLProvider aclProvider, Configuration configuration) {
        super(graph, visibilityTranslator);
        this.ontologyRepository = ontologyRepository;
        this.workspaceRepository = workspaceRepository;
        this.workQueueRepository = workQueueRepository;
        this.graphRepository = graphRepository;
        this.aclProvider = aclProvider;
        this.autoPublishComments = configuration.getBoolean("comments.autoPublish", false);
    }

    @Handle
    public ClientApiElement handle(HttpServletRequest request, @Required(name="graphVertexId") String graphVertexId, @Optional(name="propertyKey") String propertyKey, @Required(name="propertyName") String propertyName, @Optional(name="value") String valueStr, @Optional(name="value[]") String[] valuesStr, @Required(name="visibilitySource") String visibilitySource, @Optional(name="oldVisibilitySource") String oldVisibilitySource, @Optional(name="sourceInfo") String sourceInfoString, @Optional(name="metadata") String metadataString, @JustificationText String justificationText, @ActiveWorkspaceId String workspaceId, ResourceBundle resourceBundle, User user, Authorizations authorizations) throws Exception {
        boolean autoPublish;
        if (valueStr == null && valuesStr == null) {
            throw new VisalloException("Parameter: 'value' or 'value[]' is required in the request");
        }
        VisibilityValidator.validate(this.graph, this.visibilityTranslator, resourceBundle, visibilitySource, user, authorizations);
        this.checkRoutePath("vertex", propertyName, request);
        boolean isComment = this.isCommentProperty(propertyName);
        boolean bl = autoPublish = isComment && this.autoPublishComments;
        if (autoPublish) {
            workspaceId = null;
        }
        if (propertyKey == null) {
            propertyKey = this.createPropertyKey(propertyName, this.graph);
        }
        Metadata metadata = VertexiumMetadataUtil.metadataStringToMap((String)metadataString, (Visibility)this.visibilityTranslator.getDefaultVisibility());
        ClientApiSourceInfo sourceInfo = ClientApiSourceInfo.fromString((String)sourceInfoString);
        Vertex vertex = this.graph.getVertex(graphVertexId, authorizations);
        this.aclProvider.checkCanAddOrUpdateProperty((Element)vertex, propertyKey, propertyName, user);
        List<SavePropertyResults> savePropertyResults = this.saveProperty(vertex, propertyKey, propertyName, valueStr, valuesStr, justificationText, oldVisibilitySource, visibilitySource, metadata, sourceInfo, user, workspaceId, authorizations);
        this.graph.flush();
        if (!autoPublish) {
            this.workspaceRepository.updateEntityOnWorkspace(workspaceId, vertex.getId(), user);
        }
        for (SavePropertyResults savePropertyResult : savePropertyResults) {
            this.workQueueRepository.pushGraphPropertyQueue((Element)vertex, savePropertyResult.getPropertyKey(), savePropertyResult.getPropertyName(), workspaceId, visibilitySource, Priority.HIGH);
        }
        if (sourceInfo != null) {
            this.workQueueRepository.pushTextUpdated(sourceInfo.vertexId);
        }
        return ClientApiConverter.toClientApi((Element)vertex, (String)workspaceId, (Authorizations)authorizations);
    }

    private List<SavePropertyResults> saveProperty(Vertex vertex, String propertyKey, String propertyName, String valueStr, String[] valuesStr, String justificationText, String oldVisibilitySource, String visibilitySource, Metadata metadata, ClientApiSourceInfo sourceInfo, User user, String workspaceId, Authorizations authorizations) {
        Object value;
        if (valueStr == null && valuesStr != null && valuesStr.length == 1) {
            valueStr = valuesStr[0];
        }
        if (valuesStr == null && valueStr != null) {
            valuesStr = new String[]{valueStr};
        }
        if (this.isCommentProperty(propertyName)) {
            value = valueStr;
        } else {
            OntologyProperty property = this.ontologyRepository.getRequiredPropertyByIRI(propertyName);
            if (property.hasDependentPropertyIris()) {
                if (valuesStr == null) {
                    throw new VisalloException("properties with dependent properties must contain a value");
                }
                if (property.getDependentPropertyIris().size() != valuesStr.length) {
                    throw new VisalloException("properties with dependent properties must contain the same number of values. expected " + property.getDependentPropertyIris().size() + " found " + valuesStr.length);
                }
                int valuesIndex = 0;
                ArrayList<SavePropertyResults> results = new ArrayList<SavePropertyResults>();
                for (String dependentPropertyIri : property.getDependentPropertyIris()) {
                    results.addAll(this.saveProperty(vertex, propertyKey, dependentPropertyIri, valuesStr[valuesIndex++], null, justificationText, oldVisibilitySource, visibilitySource, metadata, sourceInfo, user, workspaceId, authorizations));
                }
                return results;
            }
            if (valuesStr != null && valuesStr.length > 1) {
                throw new VisalloException("properties without dependent properties must not contain more than one value.");
            }
            if (valueStr == null) {
                throw new VisalloException("properties without dependent properties must have a value");
            }
            try {
                value = property.convertString(valueStr);
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("Validation error propertyName: %s, valueStr: %s", propertyName, valueStr), (Throwable)ex);
                throw new VisalloException(ex.getMessage(), (Throwable)ex);
            }
        }
        VisibilityAndElementMutation setPropertyResult = this.graphRepository.setProperty((Element)vertex, propertyName, propertyKey, value, metadata, oldVisibilitySource, visibilitySource, workspaceId, justificationText, sourceInfo, user, authorizations);
        Vertex save = (Vertex)setPropertyResult.elementMutation.save(authorizations);
        return Lists.newArrayList((Object[])new SavePropertyResults[]{new SavePropertyResults(save, propertyKey, propertyName)});
    }

    private static class SavePropertyResults {
        private final Vertex vertex;
        private final String propertyKey;
        private final String propertyName;

        public SavePropertyResults(Vertex vertex, String propertyKey, String propertyName) {
            this.vertex = vertex;
            this.propertyKey = propertyKey;
            this.propertyName = propertyName;
        }

        public Vertex getVertex() {
            return this.vertex;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

