/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.util.Date;
import java.util.ResourceBundle;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.visallo.core.ingest.ArtifactDetectedObject;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiSourceInfo;
import org.visallo.web.clientapi.model.VisibilityJson;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;
import org.visallo.web.parameterProviders.JustificationText;
import org.visallo.web.util.VisibilityValidator;

public class ResolveDetectedObject
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ResolveDetectedObject.class);
    private static final String MULTI_VALUE_KEY_PREFIX = ResolveDetectedObject.class.getName();
    private static final String MULTI_VALUE_KEY = ResolveDetectedObject.class.getName();
    private final Graph graph;
    private final OntologyRepository ontologyRepository;
    private final WorkQueueRepository workQueueRepository;
    private final VisibilityTranslator visibilityTranslator;
    private final WorkspaceRepository workspaceRepository;
    private final TermMentionRepository termMentionRepository;
    private String artifactContainsImageOfEntityIri;

    @Inject
    public ResolveDetectedObject(Graph graph, OntologyRepository ontologyRepository, WorkQueueRepository workQueueRepository, VisibilityTranslator visibilityTranslator, WorkspaceRepository workspaceRepository, TermMentionRepository termMentionRepository) {
        this.graph = graph;
        this.ontologyRepository = ontologyRepository;
        this.workQueueRepository = workQueueRepository;
        this.visibilityTranslator = visibilityTranslator;
        this.workspaceRepository = workspaceRepository;
        this.termMentionRepository = termMentionRepository;
        this.artifactContainsImageOfEntityIri = ontologyRepository.getRelationshipIRIByIntent("artifactContainsImageOfEntity");
        if (this.artifactContainsImageOfEntityIri == null) {
            LOGGER.warn("'artifactContainsImageOfEntity' intent has not been defined. Please update your ontology.", new Object[0]);
        }
    }

    @Handle
    public ClientApiElement handle(@Required(name="artifactId") String artifactId, @Required(name="title") String title, @Required(name="conceptId") String conceptId, @Required(name="visibilitySource") String visibilitySource, @Optional(name="graphVertexId") String graphVertexId, @JustificationText String justificationText, @Optional(name="sourceInfo") String sourceInfoString, @Optional(name="originalPropertyKey") String originalPropertyKey, @Required(name="x1") double x1, @Required(name="x2") double x2, @Required(name="y1") double y1, @Required(name="y2") double y2, ResourceBundle resourceBundle, @ActiveWorkspaceId String workspaceId, User user, Authorizations authorizations) throws Exception {
        Vertex resolvedVertex;
        VertexBuilder resolvedVertexMutation;
        if (this.artifactContainsImageOfEntityIri == null) {
            this.artifactContainsImageOfEntityIri = this.ontologyRepository.getRequiredRelationshipIRIByIntent("artifactContainsImageOfEntity");
        }
        Workspace workspace = this.workspaceRepository.findById(workspaceId, user);
        VisibilityValidator.validate(this.graph, this.visibilityTranslator, resourceBundle, visibilitySource, user, authorizations);
        VisibilityJson visibilityJson = VisibilityJson.updateVisibilitySourceAndAddWorkspaceId(null, (String)visibilitySource, (String)workspaceId);
        VisalloVisibility visalloVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        Concept concept = this.ontologyRepository.getConceptByIRI(conceptId);
        Vertex artifactVertex = this.graph.getVertex(artifactId, authorizations);
        Metadata metadata = new Metadata();
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(metadata, (Object)visibilityJson, defaultVisibility);
        if (graphVertexId == null || graphVertexId.equals("")) {
            resolvedVertexMutation = this.graph.prepareVertex(visalloVisibility.getVisibility());
            VisalloProperties.CONCEPT_TYPE.setProperty((ElementMutation)resolvedVertexMutation, (Object)concept.getIRI(), defaultVisibility);
            VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation)resolvedVertexMutation, (Object)visibilityJson, defaultVisibility);
            VisalloProperties.MODIFIED_DATE.setProperty((ElementMutation)resolvedVertexMutation, (Object)new Date(), defaultVisibility);
            VisalloProperties.MODIFIED_BY.setProperty((ElementMutation)resolvedVertexMutation, (Object)user.getUserId(), defaultVisibility);
            VisalloProperties.TITLE.addPropertyValue((ElementMutation)resolvedVertexMutation, MULTI_VALUE_KEY, (Object)title, metadata, visalloVisibility.getVisibility());
            resolvedVertex = (Vertex)resolvedVertexMutation.save(authorizations);
            this.graph.flush();
            ClientApiSourceInfo sourceInfo = ClientApiSourceInfo.fromString((String)sourceInfoString);
            this.termMentionRepository.addJustification(resolvedVertex, justificationText, sourceInfo, visalloVisibility, authorizations);
            resolvedVertex = (Vertex)resolvedVertexMutation.save(authorizations);
            VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation)resolvedVertexMutation, (Object)visibilityJson, defaultVisibility);
            this.graph.flush();
            this.workspaceRepository.updateEntityOnWorkspace(workspace, resolvedVertex.getId(), user);
        } else {
            resolvedVertex = this.graph.getVertex(graphVertexId, authorizations);
            resolvedVertexMutation = resolvedVertex.prepareMutation();
        }
        Edge edge = this.graph.addEdge(artifactVertex, resolvedVertex, this.artifactContainsImageOfEntityIri, visalloVisibility.getVisibility(), authorizations);
        VisalloProperties.VISIBILITY_JSON.setProperty((Element)edge, (Object)visibilityJson, defaultVisibility, authorizations);
        ArtifactDetectedObject artifactDetectedObject = new ArtifactDetectedObject(x1, y1, x2, y2, concept.getIRI(), "user", edge.getId(), resolvedVertex.getId(), originalPropertyKey);
        String propertyKey = artifactDetectedObject.getMultivalueKey(MULTI_VALUE_KEY_PREFIX);
        VisalloProperties.DETECTED_OBJECT.addPropertyValue((Element)artifactVertex, propertyKey, (Object)artifactDetectedObject, visalloVisibility.getVisibility(), authorizations);
        resolvedVertexMutation.addPropertyValue(resolvedVertex.getId(), VisalloProperties.ROW_KEY.getPropertyName(), (Object)propertyKey, visalloVisibility.getVisibility());
        resolvedVertexMutation.save(authorizations);
        this.graph.flush();
        this.workQueueRepository.broadcastElement((Element)edge, workspaceId);
        this.workQueueRepository.pushGraphPropertyQueue((Element)artifactVertex, propertyKey, VisalloProperties.DETECTED_OBJECT.getPropertyName(), Priority.HIGH);
        return ClientApiConverter.toClientApi((Element)artifactVertex, (String)workspaceId, (Authorizations)authorizations);
    }
}

