/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.resource;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.web.VisalloResponse;

public class ResourceGet
implements ParameterizedHandler {
    private final OntologyRepository ontologyRepository;

    @Inject
    public ResourceGet(OntologyRepository ontologyRepository) {
        this.ontologyRepository = ontologyRepository;
    }

    @Handle
    public void handle(@Required(name="id") String id, @Optional(name="state") String state, VisalloResponse response) throws Exception {
        Concept concept = this.ontologyRepository.getConceptByIRI(id);
        byte[] rawImg = "selected".equals(state) && concept.hasGlyphIconSelectedResource() ? concept.getGlyphIconSelected() : concept.getGlyphIcon();
        if (rawImg == null || rawImg.length <= 0) {
            throw new VisalloResourceNotFoundException("Could not find resource with id: " + id);
        }
        response.setContentType("image/png");
        response.setHeader("Cache-Control", "max-age=300");
        response.write(rawImg);
    }
}

