/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.product;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Required;
import java.io.InputStream;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.User;
import org.visallo.web.VisalloResponse;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;

public class ProductPreview
implements ParameterizedHandler {
    private final WorkspaceRepository workspaceRepository;

    @Inject
    public ProductPreview(WorkspaceRepository workspaceRepository) {
        this.workspaceRepository = workspaceRepository;
    }

    @Handle
    public void handle(@Required(name="productId") String productId, @ActiveWorkspaceId String workspaceId, User user, VisalloResponse response) throws Exception {
        try (InputStream preview = this.workspaceRepository.getProductPreviewById(workspaceId, productId, user);){
            if (preview == null) {
                response.setStatus(404);
            } else {
                response.write(preview);
            }
        }
    }
}

