/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.admin;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONObject;
import org.visallo.core.bootstrap.lib.LibLoader;
import org.visallo.core.config.Configuration;
import org.visallo.core.ingest.FileImportSupportingFileHandler;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorker;
import org.visallo.core.ingest.graphProperty.PostMimeTypeWorker;
import org.visallo.core.ingest.graphProperty.TermMentionFilter;
import org.visallo.core.model.user.UserListener;
import org.visallo.core.status.StatusServer;
import org.visallo.core.util.ServiceLoaderUtil;
import org.visallo.web.WebAppPlugin;

public class PluginList
implements ParameterizedHandler {
    private final Configuration configuration;

    @Inject
    public PluginList(Configuration configuration) {
        this.configuration = configuration;
    }

    @Handle
    public JSONObject handle() throws Exception {
        JSONObject json = new JSONObject();
        json.put("loadedLibFiles", (Object)this.getLoadedLibFilesJson());
        json.put("graphPropertyWorkers", (Object)this.getGraphPropertyWorkersJson());
        json.put("postMimeTypeWorkers", (Object)this.getPostMimeTypeWorkersJson());
        json.put("userListeners", (Object)this.getUserListenersJson());
        json.put("libLoaders", (Object)this.getLibLoadersJson());
        json.put("fileImportSupportingFileHandlers", (Object)this.getFileImportSupportingFileHandlersJson());
        json.put("termMentionFilters", (Object)this.getTermMentionFiltersJson());
        json.put("webAppPlugins", (Object)this.getWebAppPluginsJson());
        return json;
    }

    private JSONArray getUserListenersJson() {
        JSONArray json = new JSONArray();
        for (Class userListenerClass : ServiceLoaderUtil.loadClasses(UserListener.class, (Configuration)this.configuration)) {
            json.put((Object)this.getUserListenerJson(userListenerClass));
        }
        return json;
    }

    private JSONObject getUserListenerJson(Class<? extends UserListener> userListenerClass) {
        JSONObject json = new JSONObject();
        StatusServer.getGeneralInfo((JSONObject)json, userListenerClass);
        return json;
    }

    private JSONArray getGraphPropertyWorkersJson() {
        JSONArray json = new JSONArray();
        for (Class graphPropertyWorkerClass : ServiceLoaderUtil.loadClasses(GraphPropertyWorker.class, (Configuration)this.configuration)) {
            json.put((Object)this.getGraphPropertyWorkerJson(graphPropertyWorkerClass));
        }
        return json;
    }

    private JSONObject getGraphPropertyWorkerJson(Class<? extends GraphPropertyWorker> graphPropertyWorkerClass) {
        JSONObject json = new JSONObject();
        StatusServer.getGeneralInfo((JSONObject)json, graphPropertyWorkerClass);
        return json;
    }

    private JSONArray getPostMimeTypeWorkersJson() {
        JSONArray json = new JSONArray();
        for (Class postMimeTypeWorkerClass : ServiceLoaderUtil.loadClasses(PostMimeTypeWorker.class, (Configuration)this.configuration)) {
            json.put((Object)this.getPostMimeTypeWorkerJson(postMimeTypeWorkerClass));
        }
        return json;
    }

    private JSONObject getPostMimeTypeWorkerJson(Class<? extends PostMimeTypeWorker> postMimeTypeWorkerClass) {
        JSONObject json = new JSONObject();
        StatusServer.getGeneralInfo((JSONObject)json, postMimeTypeWorkerClass);
        return json;
    }

    private JSONArray getLoadedLibFilesJson() {
        JSONArray json = new JSONArray();
        for (File loadedLibFile : LibLoader.getLoadedLibFiles()) {
            json.put((Object)this.getLoadedLibFileJson(loadedLibFile));
        }
        return json;
    }

    private JSONObject getLoadedLibFileJson(File loadedLibFile) {
        JSONObject json = new JSONObject();
        json.put("fileName", (Object)loadedLibFile.getAbsolutePath());
        return json;
    }

    private JSONArray getLibLoadersJson() {
        JSONArray json = new JSONArray();
        for (Class libLoaderClass : ServiceLoaderUtil.loadClasses(LibLoader.class, (Configuration)this.configuration)) {
            json.put((Object)this.getLibLoaderJson(libLoaderClass));
        }
        return json;
    }

    private JSONObject getLibLoaderJson(Class<? extends LibLoader> libLoaderClass) {
        JSONObject json = new JSONObject();
        StatusServer.getGeneralInfo((JSONObject)json, libLoaderClass);
        return json;
    }

    private JSONArray getFileImportSupportingFileHandlersJson() {
        JSONArray json = new JSONArray();
        for (Class fileImportSupportingFileHandlerClass : ServiceLoaderUtil.loadClasses(FileImportSupportingFileHandler.class, (Configuration)this.configuration)) {
            json.put((Object)this.getFileImportSupportingFileHandlerJson(fileImportSupportingFileHandlerClass));
        }
        return json;
    }

    private JSONObject getFileImportSupportingFileHandlerJson(Class<? extends FileImportSupportingFileHandler> fileImportSupportingFileHandlerClass) {
        JSONObject json = new JSONObject();
        StatusServer.getGeneralInfo((JSONObject)json, fileImportSupportingFileHandlerClass);
        return json;
    }

    private JSONArray getTermMentionFiltersJson() {
        JSONArray json = new JSONArray();
        for (Class termMentionFilterClass : ServiceLoaderUtil.loadClasses(TermMentionFilter.class, (Configuration)this.configuration)) {
            json.put((Object)this.getTermMentionFilterJson(termMentionFilterClass));
        }
        return json;
    }

    private JSONObject getTermMentionFilterJson(Class<? extends TermMentionFilter> termMentionFilterClass) {
        JSONObject json = new JSONObject();
        StatusServer.getGeneralInfo((JSONObject)json, termMentionFilterClass);
        return json;
    }

    private JSONArray getWebAppPluginsJson() {
        JSONArray json = new JSONArray();
        for (Class webAppPluginClass : ServiceLoaderUtil.loadClasses(WebAppPlugin.class, (Configuration)this.configuration)) {
            json.put((Object)this.getWebAppPluginJson(webAppPluginClass));
        }
        return json;
    }

    private JSONObject getWebAppPluginJson(Class<? extends WebAppPlugin> webAppPluginClass) {
        JSONObject json = new JSONObject();
        StatusServer.getGeneralInfo((JSONObject)json, webAppPluginClass);
        return json;
    }
}

