/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.admin;

import com.v5analytics.webster.App;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.Route;
import com.v5analytics.webster.annotations.ContentType;
import com.v5analytics.webster.annotations.Handle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AdminList
implements ParameterizedHandler {
    @Handle
    @ContentType(value="text/html")
    public String handle(HttpServletRequest request) throws Exception {
        App app = App.getApp((HttpServletRequest)request);
        List<String> paths = this.getPaths(app);
        return this.pathsToHtml(paths);
    }

    private String pathsToHtml(List<String> paths) {
        StringBuilder out = new StringBuilder();
        out.append("<html>");
        out.append("<head>");
        out.append("  <title>Visallo: Admin Index</title>");
        out.append("</head>");
        out.append("<body>");
        out.append("  <ul>");
        for (String path : paths) {
            out.append("    <li><a href='" + path + "'>" + path + "</a></li>");
        }
        out.append("  </ul>");
        out.append("</body>");
        out.append("</html>");
        return out.toString();
    }

    private List<String> getPaths(App app) {
        Map routes = app.getRouter().getRoutes();
        ArrayList<String> paths = new ArrayList<String>();
        for (Map.Entry routeByMethod : routes.entrySet()) {
            if (routeByMethod.getKey() != Route.Method.GET) continue;
            for (Route route : (List)routeByMethod.getValue()) {
                if (!route.getPath().startsWith("/admin/")) continue;
                paths.add(route.getPath());
            }
        }
        return paths;
    }
}

